/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class UndoAction
extends Action {
    protected EditingDomain domain;

    public UndoAction(EditingDomain domain) {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", new Object[]{""}));
        this.domain = domain;
        this.update();
    }

    public UndoAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", new Object[]{""}));
    }

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public void setEditingDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public void run() {
        this.domain.getCommandStack().undo();
    }

    public void update() {
        this.setEnabled(this.domain.getCommandStack().canUndo());
        Command undoCommand = this.domain.getCommandStack().getUndoCommand();
        if (undoCommand != null && undoCommand.getLabel() != null) {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", new Object[]{undoCommand.getLabel()}));
        } else {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", new Object[]{""}));
        }
        if (undoCommand != null && undoCommand.getDescription() != null) {
            this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item_description", new Object[]{undoCommand.getDescription()}));
        } else {
            this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item_simple_description"));
        }
    }

    @Deprecated
    public void setActiveEditor(IEditorPart editorPart) {
        this.setActiveWorkbenchPart((IWorkbenchPart)editorPart);
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }
}

