/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.oauth.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.userstorage.internal.oauth.OAuthCredentialsPersistence;
import org.eclipse.userstorage.internal.oauth.ui.OAuthApplicationData;

public class OAuthAccountsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String PAGE_ID = "org.eclipse.userstorage.ui.oauth.credentials";
    private IWorkbench workbench;
    private Collection<OAuthApplicationData> appData;
    private OAuthCredentialsPersistence persister;
    private List<OAuthCredentialsPersistence.LinkedAccount> accounts = new ArrayList<OAuthCredentialsPersistence.LinkedAccount>();
    private List<OAuthCredentialsPersistence.LinkedAccount> toRemove = new ArrayList<OAuthCredentialsPersistence.LinkedAccount>();
    private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();
    private Table table;
    private Button discardButton;

    public OAuthAccountsPreferencePage() {
        super("Linked Accounts");
        this.setDescription("Connected accounts for the Eclipse User Storage Service");
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        IExtensionRegistry registry = (IExtensionRegistry)workbench.getService(IExtensionRegistry.class);
        this.persister = OAuthCredentialsPersistence.standard();
        this.appData = OAuthApplicationData.load(registry);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        Composite tableComposite = new Composite(container, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout layout = new TableColumnLayout();
        tableComposite.setLayout((Layout)layout);
        final TableViewer tableViewer = new TableViewer(tableComposite, 67586);
        this.table = tableViewer.getTable();
        this.table.setHeaderVisible(true);
        TableViewerColumn tvcApplication = new TableViewerColumn(tableViewer, 0);
        TableColumn tableColumn = tvcApplication.getColumn();
        layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tvcApplication.getColumn().setText("Application");
        tvcApplication.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                OAuthCredentialsPersistence.LinkedAccount account = (OAuthCredentialsPersistence.LinkedAccount)cell.getElement();
                cell.setImage(OAuthAccountsPreferencePage.this.getImage(OAuthAccountsPreferencePage.this.getApplicationIcon(account)));
                cell.setText(OAuthAccountsPreferencePage.this.getApplicationName(account));
            }
        });
        TableViewerColumn tvcUser = new TableViewerColumn(tableViewer, 0);
        TableColumn tableColumn_1 = tvcUser.getColumn();
        layout.setColumnData((Widget)tableColumn_1, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tvcUser.getColumn().setText("User");
        tvcUser.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                OAuthCredentialsPersistence.LinkedAccount account = (OAuthCredentialsPersistence.LinkedAccount)cell.getElement();
                cell.setText(account.email);
            }
        });
        this.discardButton = new Button(container, 8);
        this.discardButton.setText("Discard");
        this.discardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = ((IStructuredSelection)tableViewer.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    OAuthAccountsPreferencePage.this.accounts.remove(o);
                    OAuthAccountsPreferencePage.this.toRemove.add((OAuthCredentialsPersistence.LinkedAccount)o);
                    ++n2;
                }
                tableViewer.refresh();
            }
        });
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OAuthAccountsPreferencePage.this.discardButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.accounts.addAll(Arrays.asList(this.persister.getLinkedAccounts()));
        tableViewer.setInput(this.accounts);
        this.discardButton.setEnabled(false);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(container);
        this.applyDialogFont(container);
        return container;
    }

    private OAuthApplicationData lookup(OAuthCredentialsPersistence.LinkedAccount account) {
        for (OAuthApplicationData app : this.appData) {
            if (!account.clientId.equals(app.getClientId()) || !account.authURI.equals(app.getAuthURI())) continue;
            return app;
        }
        return null;
    }

    private String getApplicationName(OAuthCredentialsPersistence.LinkedAccount account) {
        OAuthApplicationData app = this.lookup(account);
        return app != null ? app.getApplicationName() : String.valueOf(account.authURI) + " - " + account.clientId;
    }

    private ImageDescriptor getApplicationIcon(OAuthCredentialsPersistence.LinkedAccount account) {
        OAuthApplicationData app = this.lookup(account);
        if (app == null) {
            return null;
        }
        String uri = app.getImageURI();
        try {
            return uri == null ? null : ImageDescriptor.createFromURL((URL)new URL(uri));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Image getImage(ImageDescriptor icon) {
        if (icon == null) {
            return null;
        }
        Image img = this.images.get(icon);
        if (img == null) {
            img = icon.createImage();
            this.images.put(icon, img);
        }
        return img;
    }

    protected void performApply() {
        this.persister.removeLinkedAccounts(this.toRemove);
    }

    public void dispose() {
        super.dispose();
        if (this.images != null) {
            for (Image img : this.images.values()) {
                img.dispose();
            }
            this.images = null;
        }
    }
}

