/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.gpg.SExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPExtendedKeyAttribute {
    private final List<Object> values;

    public List<Object> getValues() {
        return this.values;
    }

    private PGPExtendedKeyAttribute(List<Object> list) {
        this.values = list;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        ArrayList<Object> values = new ArrayList();

        public Builder addAttribute(Object object) {
            if (object instanceof String || object instanceof SExpression.QuotedString) {
                this.values.add(object.toString());
            } else if (object instanceof byte[]) {
                this.values.add(object);
            } else if (object instanceof SExpression) {
                Builder builder = new Builder();
                Iterator<Object> iterator = ((SExpression)object).getValues().iterator();
                while (iterator.hasNext()) {
                    builder.addAttribute(iterator.next());
                }
                this.values.add(builder.build());
            } else {
                throw new IllegalArgumentException("expected either string or SExpression object.");
            }
            return this;
        }

        public PGPExtendedKeyAttribute build() {
            return new PGPExtendedKeyAttribute(Collections.unmodifiableList(this.values));
        }
    }
}

