/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.ui.Activator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedConfigurationDialog
extends TitleAreaDialog {
    private static final String BUILDER_CONFIGURATION = "Extended Version Builder Configuration";
    private static final ColumnHandler[] COLUMN_HANDLERS = new ColumnHandler[]{new ColumnHandler("ignore.malformed.versions", "Ignore malformed versions"), new ColumnHandler("ignore.feature.nature", "Ignore feature nature"), new ColumnHandler("ignore.schema.builder", "Ignore schema builder"), new ColumnHandler("ignore.debug.options", "Ignore debug options"), new ColumnHandler("ignore.missing.dependency.ranges", "Ignore missing dependency version ranges"), new ColumnHandler("ignore.lower.bound.dependency.ranges", "Ignore lax lower bound dependency versions"), new ColumnHandler("ignore.missing.export.versions", "Ignore missing package export versions"), new ColumnHandler("ignore.feature.content.changes", "Ignore feature content changes"), new ColumnHandler("ignore.feature.content.redundancy", "Ignore feature content redundancy"), new ColumnHandler("check.feature.closure.completeness", "Check feature closure completeness"), new ColumnHandler("check.feature.closure.content", "Check feature closure content"), new ColumnHandler("check.maven.pom", "Check Maven POM")};
    private final Map<IProject, VersionBuilderArguments> map = new HashMap<IProject, VersionBuilderArguments>();
    private Table table;
    private Image projectImage;

    public ExtendedConfigurationDialog(Shell parentShell, Map<IProject, VersionBuilderArguments> map) {
        super(parentShell);
        this.setShellStyle(68848);
        this.setHelpAvailable(false);
        for (Map.Entry<IProject, VersionBuilderArguments> entry : map.entrySet()) {
            VersionBuilderArguments arguments = entry.getValue();
            if (arguments != null) {
                arguments = new VersionBuilderArguments((Map)arguments);
            }
            this.map.put(entry.getKey(), arguments);
        }
    }

    public final Map<IProject, VersionBuilderArguments> getMap() {
        return this.map;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(BUILDER_CONFIGURATION);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(BUILDER_CONFIGURATION);
        this.setMessage("Select a release specification file and check additional settings.");
        this.projectImage = Activator.imageDescriptorFromPlugin((String)"org.eclipse.oomph.version.ui", (String)"icons/Project.gif").createImage();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.table = new Table(composite, 65540);
        this.table.setHeaderVisible(true);
        TableColumn column0 = new TableColumn(this.table, 0);
        column0.setWidth(300);
        column0.setText("Project");
        ColumnHandler[] columnHandlerArray = COLUMN_HANDLERS;
        int n = COLUMN_HANDLERS.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnHandler columnHandler = columnHandlerArray[n2];
            columnHandler.createColumn(this.table);
            ++n2;
        }
        ArrayList<IProject> list = new ArrayList<IProject>(this.map.keySet());
        Collections.sort(list, new Comparator<IProject>(){

            @Override
            public int compare(IProject p1, IProject p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        for (IProject project : list) {
            VersionBuilderArguments arguments = this.map.get(project);
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, project.getName());
            item.setImage(0, this.projectImage);
            if (arguments == null) {
                item.setForeground(0, this.table.getDisplay().getSystemColor(15));
                continue;
            }
            int column = 1;
            ColumnHandler[] columnHandlerArray2 = COLUMN_HANDLERS;
            int n3 = COLUMN_HANDLERS.length;
            int n4 = 0;
            while (n4 < n3) {
                ColumnHandler columnHandler = columnHandlerArray2[n4];
                columnHandler.populateItem(this.table, item, arguments, column++);
                ++n4;
            }
        }
        return dialogArea;
    }

    public boolean close() {
        if (this.projectImage != null) {
            this.projectImage.dispose();
        }
        return super.close();
    }

    private static final class ColumnHandler {
        private String key;
        private String header;

        public ColumnHandler(String key, String header) {
            this.key = key;
            this.header = header;
        }

        public void createColumn(Table table) {
            GC gc = new GC((Drawable)table);
            Point extent = gc.textExtent(this.header);
            gc.dispose();
            TableColumn column = new TableColumn(table, 0x1000000);
            column.setWidth(10 + extent.x + 10);
            column.setText(this.header);
            final ArrayList buttons = new ArrayList();
            column.setData("buttons", buttons);
            column.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = false;
                    for (Button button : buttons) {
                        if (!button.getSelection()) continue;
                        selected = true;
                    }
                    for (Button button : buttons) {
                        button.setSelection(!selected);
                        button.notifyListeners(13, null);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public void populateItem(Table table, TableItem item, final VersionBuilderArguments arguments, int column) {
            final Button button = new Button((Composite)table, 32);
            button.setSelection(this.isChecked(arguments));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnHandler.this.setChecked(arguments, button.getSelection());
                }
            });
            Point size = button.getSize();
            TableEditor editor = new TableEditor(table);
            editor.grabHorizontal = true;
            editor.minimumWidth = size.x;
            editor.minimumHeight = size.y;
            editor.setEditor((Control)button, item, column);
            List buttons = (List)table.getColumns()[column].getData("buttons");
            buttons.add(button);
        }

        protected boolean isChecked(VersionBuilderArguments arguments) {
            return "true".equals(arguments.get((Object)this.key));
        }

        protected void setChecked(VersionBuilderArguments arguments, boolean checked) {
            if (checked) {
                arguments.put((Object)this.key, (Object)Boolean.toString(true));
            } else {
                arguments.remove((Object)this.key);
            }
        }
    }
}

