/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.LiftingTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLiftExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.BytecodeTransformer;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateMemento;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.OTClassScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.ReplaceSingleNameVisitor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

public class DeclaredLifting
implements IOTConstants {
    public static final char[] OT_LIFT_DYNAMIC = "_OT$lift_dynamic".toCharArray();

    public static void transformMethodsWithDeclaredLifting(TypeDeclaration teamDecl, boolean needMethodBodies) {
        if (teamDecl.methods != null) {
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = teamDecl.methods;
            int n = teamDecl.methods.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractMethodDeclaration method = abstractMethodDeclarationArray[n2];
                DeclaredLifting.transformMethodWithDeclaredLifting(method, teamDecl, needMethodBodies);
                ++n2;
            }
        }
        DeclaredLifting.redefineLiftDynamicMethods(teamDecl, needMethodBodies);
    }

    /*
     * WARNING - void declaration
     */
    public static void transformMethodWithDeclaredLifting(AbstractMethodDeclaration method, TypeDeclaration teamDecl, boolean needMethodBody) {
        void var4_5;
        if (method.arguments == null) {
            return;
        }
        LinkedList<Object> liftingTypeArguments = new LinkedList<Object>();
        boolean bl = false;
        while (var4_5 < method.arguments.length) {
            Argument argument = method.arguments[var4_5];
            if (argument.type != null && argument.type.isDeclaredLifting()) {
                liftingTypeArguments.add(argument);
            }
            ++var4_5;
        }
        if (liftingTypeArguments.isEmpty()) {
            return;
        }
        if (method.isStatic()) {
            method.scope.problemReporter().declaredLiftingInStaticMethod(method, (Argument)liftingTypeArguments.get(0));
            return;
        }
        if (DeclaredLifting.hasBaseBoundedTypeParameters(method)) {
            for (Argument argument : liftingTypeArguments) {
                ReferenceBinding roleType = teamDecl.binding.getMemberType(((LiftingTypeReference)argument.type).roleToken);
                if (roleType == null) continue;
                DeclaredLifting.genLiftDynamicMethod(teamDecl, argument.type, roleType, needMethodBody);
            }
        }
        if (!needMethodBody) {
            return;
        }
        Statement[] statementArray = new Statement[liftingTypeArguments.size()];
        int position = 0;
        for (Argument argument : liftingTypeArguments) {
            char[] oldArgumentName = argument.name;
            LocalDeclaration declaration = DeclaredLifting.createLiftingStatement(method.scope, argument);
            if (method instanceof ConstructorDeclaration) {
                ConstructorDeclaration ctor = (ConstructorDeclaration)method;
                if (ctor.constructorCall != null) {
                    ReplaceSingleNameVisitor.performReplacement(ctor.constructorCall, ctor.scope, oldArgumentName, argument.name);
                }
                ctor.needsLifting = true;
            }
            statementArray[position++] = declaration;
        }
        Statement[] originalStatements = method.statements;
        if (originalStatements == null) {
            method.setStatements(statementArray);
        } else {
            Statement[] statementArray2 = new Statement[statementArray.length + method.statements.length];
            System.arraycopy(statementArray, 0, statementArray2, 0, statementArray.length);
            System.arraycopy(originalStatements, 0, statementArray2, statementArray.length, originalStatements.length);
            method.setStatements(statementArray2);
        }
    }

    static boolean hasBaseBoundedTypeParameters(AbstractMethodDeclaration method) {
        TypeParameter[] typeParameters = method.typeParameters();
        if (typeParameters == null) {
            return false;
        }
        TypeParameter[] typeParameterArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeParameter typeParameter = typeParameterArray[n2];
            if (typeParameter.hasBaseBound()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void transformCatch(Scope scope, Block block, Argument argument) {
        int len = block.statements.length;
        block.statements = new Statement[len + 1];
        System.arraycopy(block.statements, 0, block.statements, 1, len);
        block.statements[0] = DeclaredLifting.createLiftingStatement(scope, argument);
    }

    private static LocalDeclaration createLiftingStatement(Scope scope, Argument argument) {
        LocalDeclaration declaration;
        LiftingTypeReference ltr = (LiftingTypeReference)argument.type;
        int start = argument.type.sourceStart;
        int end = argument.type.sourceEnd;
        AstGenerator gen = new AstGenerator(start, end);
        char[] oldName = argument.name;
        char[] newName = CharOperation.concat(OT_DOLLAR_NAME, oldName);
        argument.updateName(newName);
        TypeBinding roleType = scope.getType(ltr.roleToken);
        ReferenceBinding roleRef = (ReferenceBinding)roleType;
        PotentialLiftExpression liftCall = null;
        if (!Config.isUsingAssistParser() && roleRef.isValidBinding() && roleRef.isRole() && (roleRef.tagBits & 0x20000L) == 0L && !RoleModel.hasTagBit(roleRef, 2)) {
            Reference receiverTeam = ThisReference.implicitThis();
            ReferenceBinding teamBinding = roleRef.enclosingType();
            if (TypeBinding.notEquals(teamBinding, scope.enclosingSourceType())) {
                receiverTeam = gen.qualifiedThisReference(teamBinding);
            }
            if (roleRef.baseclass() == null) {
                CompilationUnitScope baseScope;
                Binding baseType = null;
                if (scope.classScope() instanceof OTClassScope && (baseScope = ((OTClassScope)scope.classScope()).getBaseImportScope(scope)) != null) {
                    baseType = (ReferenceBinding)baseScope.getType(ltr.baseTokens, ltr.baseTokens.length);
                    baseScope.originalScope = null;
                }
                if (baseType == null || !baseType.isValidBinding()) {
                    baseType = (ReferenceBinding)scope.getType(ltr.baseTokens, ltr.baseTokens.length);
                }
                roleRef = (ReferenceBinding)TeamModel.getRoleToLiftTo(scope, (TypeBinding)baseType, roleRef, true, ltr);
                if (((TypeBinding)baseType).isTypeVariable() && roleRef == null) {
                    roleRef = (ReferenceBinding)roleType;
                }
            }
            if (roleRef != null) {
                if (ltr.baseReference.dimensions() > 0) {
                    roleType = scope.createArrayType(roleRef, ltr.baseReference.dimensions());
                }
                liftCall = new PotentialLiftExpression((Expression)receiverTeam, (Expression)gen.singleNameReference(newName), ltr.roleReference);
            }
        }
        ltr.fakedArgument = declaration = gen.localVariable(oldName, AstClone.copyTypeReference(ltr.roleReference), liftCall);
        return declaration;
    }

    public static void prepareArgLifting(TypeDeclaration teamDecl) {
        if (teamDecl.methods != null) {
            int i = 0;
            while (i < teamDecl.methods.length) {
                if (teamDecl.methods[i].isConstructor()) {
                    ConstructorDeclaration ctor = (ConstructorDeclaration)teamDecl.methods[i];
                    DeclaredLifting.prepareArgLifting(teamDecl, ctor);
                }
                ++i;
            }
        }
    }

    private static void prepareArgLifting(TypeDeclaration teamDecl, ConstructorDeclaration ctor) {
        if (ctor.arguments == null || ctor.ignoreFurtherInvestigation) {
            return;
        }
        LinkedList<LocalDeclaration> localVariables = new LinkedList<LocalDeclaration>();
        boolean changeSuperCallToCopiedThis = false;
        boolean chainArgAdded = false;
        int idx = 0;
        while (idx < ctor.arguments.length) {
            Argument argument = ctor.arguments[idx];
            TypeBinding param = ctor.binding.parameters[idx];
            int dims = param.dimensions();
            if (DeclaredLifting.isLiftableRoleOf(param = param.leafComponentType(), teamDecl.binding) && !ctor.isTSuper) {
                int start = argument.type.sourceStart;
                int end = argument.type.sourceEnd;
                AstGenerator gen = new AstGenerator(start, end);
                if (!chainArgAdded) {
                    LocalDeclaration chainVar = gen.localVariable("_OT$chainArg".toCharArray(), teamDecl.scope.getJavaLangObject(), null);
                    chainVar.isPlaceHolder = true;
                    localVariables.add(chainVar);
                    chainArgAdded = true;
                }
                char[] oldName = argument.name;
                char[] newName = CharOperation.concat(OT_DOLLAR_NAME, oldName);
                CastExpression rhs = gen.castExpression(gen.singleNameReference(newName), gen.createArrayTypeReference(((ReferenceBinding)param).getRealType(), dims), 2);
                argument.updateName(newName);
                LocalDeclaration declaration = gen.localVariable(oldName, AstClone.copyTypeReference(argument.type), (Expression)rhs);
                declaration.isPreparingForLifting = true;
                localVariables.add(declaration);
                if (ctor.constructorCall != null) {
                    ReplaceSingleNameVisitor.performReplacement(ctor.constructorCall, ctor.scope, oldName, newName);
                    boolean bl = changeSuperCallToCopiedThis = ctor.constructorCall.accessMode != 3;
                }
            }
            if (changeSuperCallToCopiedThis) {
                ExplicitConstructorCall call = ctor.constructorCall;
                call.accessMode = 3;
                AstGenerator gen = new AstGenerator(call.sourceStart, call.sourceEnd);
                int numArgs = 0;
                if (call.arguments == null) {
                    call.arguments = new Expression[1];
                } else {
                    numArgs = call.arguments.length;
                    call.arguments = new Expression[numArgs + 1];
                    System.arraycopy(call.arguments, 0, call.arguments, 0, numArgs);
                }
                call.arguments[numArgs] = TSuperHelper.createMarkerArgExpr(teamDecl.binding.superclass, gen);
                MethodModel.getModel(ctor);
            }
            ++idx;
        }
        if (!localVariables.isEmpty()) {
            int statsLen = ctor.statements == null ? 0 : ctor.statements.length;
            Statement[] statements = new Statement[localVariables.size() + statsLen];
            int i = 0;
            Iterator iter = localVariables.iterator();
            while (iter.hasNext()) {
                statements[i++] = (Statement)iter.next();
            }
            if (ctor.statements != null) {
                System.arraycopy(ctor.statements, 0, statements, i, statsLen);
            }
            ctor.setStatements(statements);
        }
    }

    private static boolean isLiftableRoleOf(TypeBinding type, ReferenceBinding enclosingTeam) {
        if (RoleTypeBinding.isRoleWithExplicitAnchor(type)) {
            return false;
        }
        if ((type = type.erasure()) instanceof MemberTypeBinding) {
            return TypeBinding.equalsEquals(((MemberTypeBinding)type).enclosingType(), enclosingTeam.erasure());
        }
        return false;
    }

    public static MethodBinding createCopyOrTurningCtor(Scope scope, MethodBinding targetConstructor, TypeBinding[] argumentTypes, boolean needsLifting, AstGenerator gen) {
        if (RoleTypeBinding.hasNonExternalizedRoleParameter(targetConstructor)) {
            return DeclaredLifting.copyTeamConstructorForDeclaredLifting(scope, targetConstructor, argumentTypes, needsLifting);
        }
        return DeclaredLifting.maybeCreateTurningCtor(scope.referenceType(), targetConstructor, gen);
    }

    public static MethodBinding copyTeamConstructorForDeclaredLifting(Scope scope, MethodBinding superTeamCtor, TypeBinding[] providedArgs, boolean needsLifting) {
        TypeDeclaration teamDecl = scope.referenceType();
        AstGenerator gen = new AstGenerator(scope.methodScope().referenceMethod().sourceStart, scope.methodScope().referenceMethod().sourceEnd);
        if (scope.isOrgObjectteamsTeam(superTeamCtor.declaringClass)) {
            return DeclaredLifting.maybeCreateTurningCtor(teamDecl, superTeamCtor, gen);
        }
        TypeBinding[] providedWithMarker = providedArgs;
        if (providedArgs.length == 0 || !TSuperHelper.isMarkerInterface(providedArgs[providedArgs.length - 1])) {
            TypeBinding lastParam = null;
            if (superTeamCtor.parameters.length > 0) {
                lastParam = superTeamCtor.parameters[superTeamCtor.parameters.length - 1];
            }
            TypeBinding marker = lastParam != null && TSuperHelper.isMarkerInterface(lastParam) ? lastParam : TSuperHelper.getMarkerInterface(scope, superTeamCtor.declaringClass);
            providedWithMarker = AstEdit.extendTypeArray(providedArgs, marker);
        }
        MethodBinding selfcall = null;
        AbstractMethodDeclaration src = superTeamCtor.sourceMethod();
        if (src != null) {
            if (src.ignoreFurtherInvestigation) {
                return null;
            }
            ConstructorDeclaration srcCtor = (ConstructorDeclaration)src;
            if (src.isCopied) {
                if (src.model != null) {
                    selfcall = src.model.adjustedSelfcall;
                }
            } else if (srcCtor.constructorCall != null) {
                Dependencies.ensureTeamState(superTeamCtor.declaringClass.getTeamModel(), 22);
                selfcall = srcCtor.constructorCall.binding;
            } else {
                if (!src.scope.compilationUnitScope().referenceContext.parseMethodBodies) {
                    MethodBinding result = new MethodBinding(1, providedArgs, null, superTeamCtor.declaringClass);
                    return result;
                }
                selfcall = superTeamCtor.declaringClass.superclass().getExactConstructor(Binding.NO_PARAMETERS);
            }
        } else {
            if (superTeamCtor.bytecodeMissing || superTeamCtor.model == null) {
                return null;
            }
            selfcall = new BytecodeTransformer().peekConstructorCall(teamDecl.getTeamModel(), superTeamCtor.model, scope.environment());
        }
        MethodBinding adjustedSelfcall = null;
        if (selfcall == null) {
            if (!superTeamCtor.bytecodeMissing) {
                scope.problemReporter().unsupportedRoleDataflow(scope.methodScope().referenceMethod(), superTeamCtor);
            }
        } else {
            TypeBinding[] selfCallProvidedArgs = providedWithMarker;
            adjustedSelfcall = DeclaredLifting.maybeCopyCtorForSelfCall(scope, selfcall, selfCallProvidedArgs, needsLifting, gen);
            MethodBinding existingConstructor = teamDecl.binding.getExactConstructor(providedWithMarker);
            if (existingConstructor != null) {
                if (adjustedSelfcall != null) {
                    MethodModel model = MethodModel.getModel(existingConstructor);
                    model.adjustSelfcall(selfcall, adjustedSelfcall);
                }
                return existingConstructor;
            }
        }
        ConstructorDeclaration newCtor = gen.constructor(teamDecl.compilationResult, 1, teamDecl.name, AstConverter.createArgumentsFromParameters(providedWithMarker, gen));
        int i = 0;
        while (i < superTeamCtor.parameters.length) {
            if (RoleTypeBinding.isRoleWithExplicitAnchor(superTeamCtor.parameters[i])) {
                RoleTypeBinding requiredRTB = (RoleTypeBinding)superTeamCtor.parameters[i];
                if (requiredRTB._argumentPosition > -1) {
                    Argument newArgument = newCtor.arguments[requiredRTB._argumentPosition];
                    newArgument.modifiers |= 0x10;
                    newArgument.name = ((RoleTypeBinding)providedArgs[i])._teamAnchor.internalName();
                }
            }
            ++i;
        }
        newCtor.isTSuper = true;
        newCtor.isCopied = true;
        AstEdit.addMethod(teamDecl, newCtor, false, false, superTeamCtor);
        MethodModel model = MethodModel.getModel(newCtor);
        if (needsLifting) {
            model.liftedParams = superTeamCtor.parameters;
        }
        if (adjustedSelfcall != null) {
            model.adjustSelfcall(selfcall, adjustedSelfcall);
        }
        newCtor.binding.copiedInContext = teamDecl.binding;
        newCtor.sourceMethodBinding = superTeamCtor;
        return newCtor.binding;
    }

    private static MethodBinding maybeCopyCtorForSelfCall(Scope scope, MethodBinding selfcall, TypeBinding[] providedArgs, boolean needsLifting, AstGenerator gen) {
        TypeBinding[] parameters = selfcall.parameters;
        assert (providedArgs.length >= parameters.length);
        if (providedArgs.length > parameters.length) {
            TypeBinding[] typeBindingArray = providedArgs;
            providedArgs = new TypeBinding[parameters.length];
            System.arraycopy(typeBindingArray, 0, providedArgs, 0, parameters.length);
        }
        boolean hasProblematicArg = false;
        int i = 0;
        while (i < parameters.length) {
            if (!providedArgs[i].isCompatibleWith(parameters[i])) {
                if (!TSuperHelper.isMarkerInterface(parameters[i])) {
                    hasProblematicArg = true;
                    TypeBinding roleType = TeamModel.getRoleToLiftTo(scope, providedArgs[i], parameters[i], true, scope.referenceType().superclass);
                    if (roleType != null) {
                        return DeclaredLifting.createCopyOrTurningCtor(scope, selfcall, DeclaredLifting.mergeSelfcallArgs(providedArgs, parameters), needsLifting, gen);
                    }
                }
            } else if (RoleTypeBinding.isRoleWithoutExplicitAnchor(parameters[i])) {
                hasProblematicArg = true;
            }
            ++i;
        }
        if (selfcall.declaringClass.isTeam() && !hasProblematicArg) {
            return DeclaredLifting.maybeCreateTurningCtor(scope.referenceType(), selfcall, gen);
        }
        return null;
    }

    private static TypeBinding[] mergeSelfcallArgs(TypeBinding[] thisProvidedArgs, TypeBinding[] superExpectedArgs) {
        TypeBinding[] result = new TypeBinding[thisProvidedArgs.length];
        int i = 0;
        while (i < result.length) {
            result[i] = TSuperHelper.isMarkerInterface(superExpectedArgs[i]) ? superExpectedArgs[i] : thisProvidedArgs[i];
            ++i;
        }
        return result;
    }

    public static MethodBinding maybeCreateTurningCtor(TypeDeclaration teamDecl, MethodBinding superTeamCtor, AstGenerator gen) {
        MethodBinding existingCtor;
        Dependencies.ensureTeamState(teamDecl.binding.superclass().getTeamModel(), 22);
        boolean hasMarkerArg = superTeamCtor.parameters.length > 0 && TSuperHelper.isMarkerInterface(superTeamCtor.parameters[superTeamCtor.parameters.length - 1]);
        TypeBinding[] newParams = superTeamCtor.parameters;
        if (!hasMarkerArg) {
            TypeBinding markerType = TSuperHelper.getMarkerInterface(teamDecl.scope, superTeamCtor.declaringClass);
            newParams = AstEdit.extendTypeArray(superTeamCtor.parameters, markerType);
        }
        if ((existingCtor = teamDecl.binding.getExactConstructor(newParams)) != null) {
            return existingCtor;
        }
        Argument[] arguments = AstConverter.createArgumentsFromParameters(superTeamCtor.parameters, gen);
        ConstructorDeclaration newCtor = gen.constructor(teamDecl.compilationResult, 1, teamDecl.name, arguments);
        if (!hasMarkerArg) {
            TSuperHelper.addMarkerArg(newCtor, superTeamCtor.declaringClass);
            arguments = newCtor.arguments;
        }
        newCtor.constructorCall = new ExplicitConstructorCall(2);
        int length = superTeamCtor.parameters.length;
        Expression[] selfcallArgs = new Expression[length];
        int i = 0;
        while (i < length) {
            selfcallArgs[i] = gen.singleNameReference(arguments[i].name);
            ++i;
        }
        newCtor.constructorCall.arguments = selfcallArgs;
        newCtor.setStatements(new Statement[0]);
        newCtor.isTSuper = true;
        AstEdit.addMethod(teamDecl, newCtor);
        return newCtor.binding;
    }

    public static void redefineLiftDynamicMethods(TypeDeclaration teamDecl, boolean needMethodBodies) {
        ReferenceBinding superTeam = teamDecl.binding.superclass();
        if (superTeam != null && superTeam.id != 126) {
            Dependencies.ensureBindingState(superTeam, 11);
            Statement location = teamDecl.superclass != null ? teamDecl.superclass : teamDecl;
            MethodBinding[] methodBindingArray = superTeam.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodBinding method = methodBindingArray[n2];
                if (CharOperation.prefixEquals(OT_LIFT_DYNAMIC, method.selector)) {
                    ReferenceBinding roleType = (ReferenceBinding)TeamModel.strengthenRoleType(teamDecl.binding, method.returnType);
                    DeclaredLifting.genLiftDynamicMethod(teamDecl, location, roleType, needMethodBodies);
                }
                ++n2;
            }
        }
    }

    public static void genLiftDynamicMethod(TypeDeclaration teamDecl, ASTNode ref, TypeBinding roleType, boolean needMethodBody) {
        char[] dynamicLiftingSelector = DeclaredLifting.dynamicLiftSelector(roleType);
        if (teamDecl.binding.getMethods(dynamicLiftingSelector) != Binding.NO_METHODS) {
            return;
        }
        if (roleType.isArrayType()) {
            teamDecl.scope.problemReporter().missingImplementation(ref, "Generic lifting of array not yet implemented.");
        } else if (roleType.isBaseType()) {
            teamDecl.scope.problemReporter().primitiveTypeNotAllowedForLifting(teamDecl, ref, roleType);
        } else {
            AstGenerator gen = new AstGenerator(ref);
            MethodDeclaration dynLiftMeth = gen.method(teamDecl.compilationResult(), 4, roleType.erasure(), dynamicLiftingSelector, new Argument[]{gen.argument(IOTConstants.BASE, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT))});
            dynLiftMeth.statements = new Statement[]{gen.emptyStatement()};
            int problemId = teamDecl.getTeamModel().canLiftingFail((ReferenceBinding)roleType.erasure());
            if (problemId == 0) {
                HashSet<ReferenceBinding> mappedBases = new HashSet<ReferenceBinding>();
                ReferenceBinding[] referenceBindingArray = ((ReferenceBinding)roleType).roleModel.getBoundDescendants();
                int n = referenceBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceBinding boundRole = referenceBindingArray[n2];
                    if (mappedBases.contains(boundRole.baseclass())) {
                        problemId = 141003;
                        break;
                    }
                    mappedBases.add(boundRole.baseclass());
                    ++n2;
                }
            }
            if (problemId != 0) {
                AstEdit.addException(dynLiftMeth, gen.qualifiedTypeReference(IOTConstants.O_O_LIFTING_FAILED_EXCEPTION), false);
            }
            dynLiftMeth.hasParsedStatements = true;
            AstEdit.addMethod(teamDecl, dynLiftMeth);
            dynLiftMeth.binding.returnType = ((ReferenceBinding)roleType).getRealType().erasure();
            if (needMethodBody) {
                dynLiftMeth.statements[0] = DeclaredLifting.generateDynamicSwitch(dynLiftMeth.scope, (ReferenceBinding)roleType, problemId, gen);
                if (StateMemento.hasMethodResolveStarted(teamDecl.binding)) {
                    dynLiftMeth.statements[0].resolve(dynLiftMeth.scope);
                }
            }
        }
    }

    public static char[] dynamicLiftSelector(TypeBinding roleType) {
        return CharOperation.concat(OT_LIFT_DYNAMIC, roleType.sourceName());
    }

    static Statement generateDynamicSwitch(BlockScope scope, ReferenceBinding roleType, int problemId, AstGenerator gen) {
        IfStatement ifStat;
        ReferenceBinding[] boundDescendants = roleType.roleModel.getBoundDescendants();
        int len = boundDescendants.length;
        if (len == 0) {
            return gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_ERROR), new Expression[]{gen.stringLiteral(CharOperation.concat("Lifting impossible, role has no bound descendants: ".toCharArray(), roleType.readableName()))}));
        }
        LookupEnvironment environment = scope.compilationUnitScope().environment;
        IfStatement current = ifStat = DeclaredLifting.genNewIf(scope, gen, boundDescendants[0], environment);
        int i = 1;
        while (i < len) {
            IfStatement newIf = DeclaredLifting.genNewIf(scope, gen, boundDescendants[i], environment);
            current.elseStatement = newIf;
            current = newIf;
            ++i;
        }
        current.elseStatement = Lifting.genLiftingFailedException(IOTConstants.BASE, roleType, problemId, gen);
        return ifStat;
    }

    private static IfStatement genNewIf(BlockScope scope, AstGenerator gen, ReferenceBinding boundDescendant, LookupEnvironment environment) {
        TypeBinding boundBase = boundDescendant.baseclass();
        if (RoleTypeBinding.isRoleWithExplicitAnchor(boundBase)) {
            if (boundBase.isParameterizedType()) {
                RoleTypeBinding baseRole = (RoleTypeBinding)boundBase;
                boundBase = environment.createParameterizedType(baseRole._declaredRoleType, null, baseRole._teamAnchor, -1, baseRole.enclosingType(), Binding.NO_ANNOTATIONS);
            }
        } else {
            boundBase = boundBase.erasure();
        }
        return gen.ifStatement((Expression)gen.instanceOfExpression(gen.singleNameReference(IOTConstants.BASE), gen.typeReference(boundBase)), gen.returnStatement(Lifting.liftCall(scope, gen.thisReference(), gen.castExpression(gen.singleNameReference(IOTConstants.BASE), gen.typeReference(boundBase), 0), boundBase, boundDescendant, false)), null);
    }
}

