/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.core.ICalloutMapping;
import org.eclipse.objectteams.otdt.core.IMethodSpec;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.core.AbstractCalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.ResolvedCalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.util.MethodData;

public class CalloutMapping
extends AbstractCalloutMapping
implements ICalloutMapping {
    private boolean isOverride;
    private IMethod baseMethod;
    private MethodData baseMethodHandle;
    private int declaredModifiers;

    public CalloutMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IType role, IMethod corrJavaMethod, MethodData roleMethodHandle, MethodData baseMethodHandle, boolean hasSignature, boolean isOverride, int declaredModifiers, boolean addAsChild) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 103, role, corrJavaMethod, roleMethodHandle, baseMethodHandle, hasSignature, isOverride, declaredModifiers, addAsChild);
    }

    protected CalloutMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod corrJavaMethod, MethodData roleMethodHandle, MethodData baseMethodHandle, boolean hasSignature, boolean isOverride, int declaredModifiers) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, elementType, corrJavaMethod, parentRole, roleMethodHandle, hasSignature);
        this.isOverride = isOverride;
        this.baseMethodHandle = baseMethodHandle;
        this.declaredModifiers = declaredModifiers;
    }

    protected CalloutMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod corrJavaMethod, MethodData roleMethodHandle, MethodData baseMethodHandle, boolean hasSignature, boolean isOverride, int declaredModifiers, boolean addAsChild) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, elementType, corrJavaMethod, parentRole, roleMethodHandle, hasSignature, addAsChild);
        this.isOverride = isOverride;
        this.baseMethodHandle = baseMethodHandle;
        this.declaredModifiers = declaredModifiers;
    }

    @Override
    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public String getElementName() {
        StringBuffer name = new StringBuffer(super.getElementName());
        name.append(" -> ");
        if (this.baseMethodHandle == null) {
            name.append("(unknown)");
        } else if (this.hasSignature()) {
            name.append(this.baseMethodHandle.toString());
        } else {
            name.append(this.baseMethodHandle.getSelector());
        }
        return name.toString();
    }

    @Override
    public int getMappingKind() {
        return 103;
    }

    @Override
    public int getDeclaredModifiers() {
        return this.declaredModifiers;
    }

    @Override
    public int getFlags() throws JavaModelException {
        return this.declaredModifiers;
    }

    @Override
    public IMethod getBoundBaseMethod() throws JavaModelException {
        if (this.baseMethod == null) {
            this.baseMethod = this.findBaseMethod();
        }
        return this.baseMethod;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CalloutMapping)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "callout " + super.toString();
    }

    private IMethod findBaseMethod() throws JavaModelException {
        if (this.baseMethodHandle == null) {
            return null;
        }
        IRoleType roleClass = this.getDeclaringRole();
        IType baseClass = roleClass.getBaseClass();
        IType[] typeParents = TypeHelper.getSuperTypes(baseClass);
        return this.findMethod(typeParents, this.baseMethodHandle);
    }

    @Override
    public IMethodSpec getBaseMethodHandle() {
        return this.baseMethodHandle;
    }

    @Override
    protected char getMappingKindChar() {
        if (this.isOverride) {
            return 'O';
        }
        return 'o';
    }

    @Override
    protected void getBaseMethodsForHandle(StringBuffer buff) {
        if (this.baseMethodHandle != null) {
            this.getMethodForHandle(this.baseMethodHandle, buff);
        }
    }

    @Override
    public OTJavaElement resolved(char[] uniqueKey) {
        ResolvedCalloutMapping resolvedHandle = new ResolvedCalloutMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), this.getElementType(), (IType)this.getParent(), this.getIMethod(), this.getRoleMethodHandle(), this.baseMethodHandle, this.hasSignature(), this.isOverride(), this.getDeclaredModifiers(), new String(uniqueKey));
        return resolvedHandle;
    }

    @Override
    public String[] getExceptionTypes() throws JavaModelException {
        if (this.roleMethodHandle != null && this.roleMethodHandle.hasSignature()) {
            try {
                return this.getIMethod().getExceptionTypes();
            }
            catch (JavaModelException jme) {
                return new String[0];
            }
        }
        return this.getIMethod().getExceptionTypes();
    }

    @Override
    public ILocalVariable[] getParameters() throws JavaModelException {
        return null;
    }
}

