/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize;

import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.model.ColumnDateFilter;
import org.eclipse.nebula.widgets.xviewer.core.model.DateRangeType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.core.util.Strings;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.ColumnFilterDialog;
import org.eclipse.swt.widgets.Display;

public class ColumnFilterDataUI {
    private final XViewer xViewer;

    public ColumnFilterDataUI(XViewer xViewer) {
        this.xViewer = xViewer;
    }

    public void createWidgets() {
    }

    public void promptSetFilter(XViewerColumn column) {
        int result;
        String columnName = column.getId().replaceFirst(".*\\.", "");
        ColumnFilterDialog ed = new ColumnFilterDialog(Display.getCurrent().getActiveShell(), XViewerText.get("ColumnFilterDataUI.title"), XViewerText.get("ColumnFilterDataUI.prompt", columnName), 3, new String[]{XViewerText.get("button.ok"), XViewerText.get("button.clear"), XViewerText.get("button.clear_all"), XViewerText.get("button.cancel")}, 0, column);
        String str = this.xViewer.getCustomizeMgr().getColumnFilterData().getFilterText(column.getId());
        if (str != null && !str.equals("")) {
            ed.setEntry(str);
        }
        if ((result = ed.open()) == 0) {
            this.xViewer.getCustomizeMgr().setColumnFilterText(column.getId(), ed.getEntry());
            this.xViewer.getCustomizeMgr().setColumnDateFilter(column.getId(), ed.getDateRangeType(), ed.getDate1(), ed.getDate2());
        } else if (result == 1) {
            this.xViewer.getCustomizeMgr().setColumnFilterText(column.getId(), null);
            this.xViewer.getCustomizeMgr().setColumnDateFilter(column.getId(), DateRangeType.None, null, null);
        } else if (result == 2) {
            this.xViewer.getCustomizeMgr().clearAllColumnFilters();
        }
    }

    public void appendToStatusLabel(StringBuilder sb) {
        for (String colId : this.xViewer.getCustomizeMgr().getColumnFilterData().getColIds()) {
            ColumnDateFilter dateFilter;
            String filterText = this.xViewer.getCustomizeMgr().getColumnFilterData().getFilterText(colId);
            if (Strings.isValid((String)filterText)) {
                sb.append("[" + colId + " = " + filterText + "]");
            }
            if ((dateFilter = this.xViewer.getCustomizeMgr().getColumnFilterData().getDateFilter(colId)) == null) continue;
            sb.append("[" + colId + " = " + dateFilter.getType().name() + " ");
            sb.append(XViewerLib.getDateFromPattern(dateFilter.getDate1(), "MM/dd/yyyy hh:mm a"));
            if (dateFilter.getType() == DateRangeType.Between_Dates) {
                sb.append(" and " + XViewerLib.getDateFromPattern(dateFilter.getDate2(), "MM/dd/yyyy hh:mm a"));
            }
            sb.append("]");
        }
    }
}

