/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.stepbar;

import org.eclipse.nebula.widgets.stepbar.Stepbar;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StepBarSnippet {
    private static Shell shell;
    private static int index;
    private static boolean error;
    private static Stepbar bar;

    static {
        index = 0;
        error = false;
    }

    public static void main(String[] args) {
        Display display = new Display();
        shell = new Shell(display);
        shell.setText("Stepbar Snippet");
        shell.setLayout((Layout)new GridLayout(2, true));
        shell.setBackground(display.getSystemColor(1));
        shell.setLayout((Layout)new GridLayout(2, false));
        String[] texts = new String[]{"Text content for the first step\n...\n...\n...", "Text content for the second step\nPlease enter additional data\n...\n...", "Text content for the last step\nAlmoste done :)\n...\n..."};
        bar = new Stepbar((Composite)shell, 3072);
        bar.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        bar.setSteps(new String[]{"First step", "Second step", "Third step"});
        Label lbl = new Label((Composite)shell, 0);
        lbl.setBackground(shell.getBackground());
        lbl.setText(texts[0]);
        GridData lblGridData = new GridData(4, 4, false, false, 2, 1);
        lblGridData.widthHint = 600;
        lblGridData.heightHint = 100;
        lbl.setLayoutData((Object)lblGridData);
        Button previous = new Button((Composite)shell, 8);
        previous.setText("Previous step");
        previous.setEnabled(false);
        previous.setLayoutData((Object)new GridData(1, 4, false, false));
        Button next = new Button((Composite)shell, 8);
        next.setText("Next step");
        next.setLayoutData((Object)new GridData(3, 4, false, false));
        previous.addListener(13, e -> {
            if (error) {
                e.doit = false;
                return;
            }
            next.setEnabled(true);
            previous.setEnabled(--index != 0);
            lbl.setText(texts[index]);
            bar.setCurrentStep(index);
        });
        next.addListener(13, e -> {
            if (error) {
                e.doit = false;
                return;
            }
            next.setEnabled(++index != bar.getSteps().size() - 1);
            previous.setEnabled(true);
            lbl.setText(texts[index]);
            bar.setCurrentStep(index);
        });
        Label separator = new Label((Composite)shell, 258);
        separator.setBackground(shell.getBackground());
        separator.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridData bottomGD = new GridData(1, 4, true, false, 2, 1);
        bottomGD.widthHint = 220;
        Button toggleBottom = new Button((Composite)shell, 2);
        toggleBottom.setText("Text above the circle (SWT.TOP)");
        toggleBottom.setLayoutData((Object)bottomGD);
        toggleBottom.addListener(13, e -> {
            bar.dispose();
            bar = new Stepbar((Composite)shell, (toggleBottom.getSelection() ? 128 : 1024) | 0x800);
            bar.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            bar.setSteps(new String[]{"First step", "Second step", "Third step"});
            bar.moveAbove((Control)lbl);
            shell.layout();
        });
        Button toggleShowAdditionalStep = new Button((Composite)shell, 2);
        toggleShowAdditionalStep.setText("Show additional step");
        toggleShowAdditionalStep.setLayoutData((Object)bottomGD);
        toggleShowAdditionalStep.addListener(13, e -> {
            if (toggleShowAdditionalStep.getSelection()) {
                bar.setSteps(new String[]{"First step", "Second step", "Additional step", "Third step"});
            } else {
                bar.setSteps(new String[]{"First step", "Second step", "Third step"});
            }
        });
        Button toggleShowError = new Button((Composite)shell, 2);
        toggleShowError.setText("Show error on step");
        toggleShowError.setLayoutData((Object)bottomGD);
        toggleShowError.addListener(13, e -> {
            error = !error;
            bar.setErrorState(error);
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

