/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.example;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.customize.XViewerCustomizations;
import org.eclipse.nebula.widgets.xviewer.example.MyDefaultCustomizations;
import org.eclipse.nebula.widgets.xviewer.example.util.FileUtil;
import org.eclipse.nebula.widgets.xviewer.example.util.MatchFilter;
import org.eclipse.nebula.widgets.xviewer.example.util.MyLib;
import org.eclipse.nebula.widgets.xviewer.example.util.MyLog;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;

public class MyXViewerCustomizations
extends XViewerCustomizations {
    public void deleteCustomization(CustomizeData custData) throws Exception {
        boolean success;
        File file = new File(this.getFilename(custData));
        if (file.exists() && !(success = file.delete())) {
            throw new XViewerException("Delete Customization Failed");
        }
    }

    public List<CustomizeData> getSavedCustDatas() throws XViewerException {
        ArrayList<CustomizeData> custDatas = new ArrayList<CustomizeData>();
        custDatas.add(MyDefaultCustomizations.getCompletionCustomization());
        custDatas.add(MyDefaultCustomizations.getDescriptionCustomization());
        String userHome = System.getProperty("user.home");
        for (String filename : MyLib.readListFromDir(new File(userHome), new MatchFilter("XViewer_CustData_.*\\.xml"), true)) {
            custDatas.add(new CustomizeData(FileUtil.readFile(String.valueOf(userHome) + "/" + filename)));
        }
        return custDatas;
    }

    public CustomizeData getUserDefaultCustData() throws XViewerException {
        File file = new File(this.getDefaultFilename());
        if (!file.exists()) {
            return null;
        }
        String defaultGuid = FileUtil.readFile(file).replaceAll("\\s", "");
        if (defaultGuid != null) {
            for (CustomizeData custData : this.getSavedCustDatas()) {
                if (!custData.getGuid().equals(defaultGuid)) continue;
                return custData;
            }
        }
        return null;
    }

    public boolean isCustomizationPersistAvailable() {
        return true;
    }

    public boolean isCustomizationUserDefault(CustomizeData custData) throws XViewerException {
        File file = new File(this.getDefaultFilename());
        if (!file.exists()) {
            return false;
        }
        String defaultGuid = FileUtil.readFile(this.getDefaultFilename()).replaceAll("\\s", "");
        return custData.getGuid().equals(defaultGuid);
    }

    public void saveCustomization(CustomizeData custData) throws Exception {
        MyLib.writeStringToFile(custData.getXml(true), new File(this.getFilename(custData)));
        Thread.sleep(2000L);
    }

    private String getFilename(CustomizeData custData) {
        String userHome = System.getProperty("user.home");
        return String.valueOf(userHome) + "/" + "XViewer_CustData_" + custData.getGuid() + ".xml";
    }

    private String getDefaultFilename() {
        String userHome = System.getProperty("user.home");
        return String.valueOf(userHome) + "/" + "XViewer_CustDataUserDefault.txt";
    }

    public void setUserDefaultCustData(CustomizeData newCustData, boolean set) throws XViewerException {
        if (set) {
            try {
                MyLib.writeStringToFile(newCustData.getGuid(), new File(this.getDefaultFilename()));
            }
            catch (IOException ex) {
                MyLog.logAndPopup(Activator.class, Level.SEVERE, ex);
            }
        } else {
            boolean success;
            File file = new File(this.getDefaultFilename());
            if (file.exists() && !(success = file.delete())) {
                throw new XViewerException("Delete Customization Failed");
            }
        }
    }
}

