/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.jface;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.nebula.widgets.geomap.PointD;
import org.eclipse.nebula.widgets.geomap.internal.URLService;
import org.eclipse.nebula.widgets.geomap.jface.Located;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SearchServer
extends URLService {
    public SearchServer(String url, String urlFormat) {
        super(url, urlFormat);
    }

    public SearchServer(String url) {
        this.parseUrl(url, "format=xml&q={0}");
    }

    @Override
    protected Object[] getURLFormatArguments(Object ref) {
        return new Object[]{ref};
    }

    public String getSearchURL(String search) {
        return this.getServiceURL(search);
    }

    protected static double tryDouble(String s) {
        try {
            return Double.valueOf(s);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    protected boolean checkPath(String[] qNames, AbstractList<String> path) {
        int i = 0;
        while (i < qNames.length) {
            int pathPos = path.size() - i - 1;
            if (pathPos < 0 || !qNames[qNames.length - i - 1].equals(path.get(pathPos))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Object startElement(String qName, Stack<String> path, Attributes attributes, Stack<Object> objects) {
        return null;
    }

    protected Object characters(String qName, Stack<String> path, char[] ch, int start, int length, Stack<Object> objects) {
        return null;
    }

    protected Object endElement(String qName, Stack<String> path, Stack<Object> objects) {
        return null;
    }

    public Object[] doSearch(String search) {
        return this.doSearchInternal(search);
    }

    private Object[] doSearchInternal(String search) {
        final ArrayList results = new ArrayList();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            final Stack path = new Stack();
            final Stack objects = new Stack();
            factory.newSAXParser().parse(this.getSearchURL(search), new DefaultHandler(){

                private void addResult(Object result) {
                    if (result != null) {
                        results.add(result);
                    }
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    this.addResult(SearchServer.this.startElement(qName, path, attributes, objects));
                    path.push(qName);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    this.addResult(SearchServer.this.endElement(qName, path, objects));
                    path.pop();
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    String qName = (String)path.pop();
                    this.addResult(SearchServer.this.characters(qName, path, ch, start, length, objects));
                    path.push(qName);
                }
            });
            return results.size() > 0 ? results.toArray() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Result
    extends Located.Static {
        private double lon = Double.NaN;
        private double lat = Double.NaN;
        private String name;
        private String text;

        @Override
        public PointD getLonLat() {
            return Double.isNaN(this.lon) || Double.isNaN(this.lat) ? null : new PointD(this.lon, this.lat);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name.trim();
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text.trim();
        }

        public double getLon() {
            return this.lon;
        }

        public void setLon(double lon) {
            this.lon = lon;
        }

        public void setLon(String lon) {
            this.lon = SearchServer.tryDouble(lon.trim());
        }

        public double getLat() {
            return this.lat;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public void setLat(String lat) {
            this.lat = SearchServer.tryDouble(lat.trim());
        }

        public String toString() {
            return "SearchResult [text=" + this.text + ", location=" + this.getLonLat() + "]";
        }
    }
}

