/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTWindowEditor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class PTRectangleEditor
extends PTWindowEditor {
    private Text x;
    private Text y;
    private Text width;
    private Text height;

    @Override
    protected void createContent(Shell shell, PTProperty property) {
        Label xLabel = new Label((Composite)shell, 0);
        xLabel.setLayoutData((Object)new GridData(3, 1, false, false));
        xLabel.setText("X");
        this.x = new Text((Composite)shell, 2048);
        this.x.setLayoutData((Object)new GridData(4, 1, true, false));
        if (property.getValue() != null) {
            Rectangle rect = (Rectangle)property.getValue();
            this.x.setText(String.valueOf(rect.x));
        }
        this.addVerifyListeners(this.x);
        Label yLabel = new Label((Composite)shell, 0);
        yLabel.setLayoutData((Object)new GridData(3, 1, false, false));
        yLabel.setText("Y");
        this.y = new Text((Composite)shell, 2048);
        this.y.setLayoutData((Object)new GridData(4, 1, true, false));
        if (property.getValue() != null) {
            Rectangle rect = (Rectangle)property.getValue();
            this.y.setText(String.valueOf(rect.y));
        }
        this.addVerifyListeners(this.y);
        Label widthLabel = new Label((Composite)shell, 0);
        widthLabel.setLayoutData((Object)new GridData(3, 1, false, false));
        widthLabel.setText(ResourceManager.getLabel((String)"width"));
        this.width = new Text((Composite)shell, 2048);
        this.width.setLayoutData((Object)new GridData(4, 1, true, false));
        if (property.getValue() != null) {
            Rectangle rect = (Rectangle)property.getValue();
            this.x.setText(String.valueOf(rect.width));
        }
        this.addVerifyListeners(this.width);
        Label heightLabel = new Label((Composite)shell, 0);
        heightLabel.setLayoutData((Object)new GridData(3, 1, false, false));
        heightLabel.setText(ResourceManager.getLabel((String)"height"));
        this.height = new Text((Composite)shell, 2048);
        this.height.setLayoutData((Object)new GridData(4, 1, true, false));
        if (property.getValue() != null) {
            Rectangle rect = (Rectangle)property.getValue();
            this.y.setText(String.valueOf(rect.height));
        }
        this.addVerifyListeners(this.height);
    }

    @Override
    protected void fillProperty(Item item, PTProperty property) {
        Rectangle r = new Rectangle(this.getIntValue(this.x), this.getIntValue(this.y), this.getIntValue(this.width), this.getIntValue(this.height));
        property.setValue(r);
        if (item instanceof TableItem) {
            ((TableItem)item).setText(1, this.getTextFor(property));
        } else {
            ((TreeItem)item).setText(1, this.getTextFor(property));
        }
    }

    @Override
    protected String getTextFor(PTProperty property) {
        if (property.getValue() == null) {
            return "(null)";
        }
        Rectangle rect = (Rectangle)property.getValue();
        return "[" + rect.x + "," + rect.y + "," + rect.width + "," + rect.height + "]";
    }
}

