/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.stepbar;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class Stepbar
extends Canvas {
    private static final int MINIMUM_LINE_WIDTH = 80;
    private static final int CIRCLE_DIAMETER = 24;
    private static final int VERTICAL_SPACE = 14;
    private static final int SPACING = 4;
    private Color unselectedColor;
    private Color textColor;
    private final Color errorColor;
    private List<String> steps = new ArrayList<String>();
    private boolean bottom = (this.getStyle() & 0x400) != 0;
    private int currentStep = 0;
    private boolean onError = false;

    public Stepbar(Composite parent, int style) {
        super(parent, Stepbar.checkStyle(style));
        this.textColor = this.getDisplay().getSystemColor(2);
        this.unselectedColor = SWTGraphicUtil.getColorSafely((int)217, (int)217, (int)217);
        this.setForeground(SWTGraphicUtil.getColorSafely((int)0, (int)147, (int)249));
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.errorColor = SWTGraphicUtil.getColorSafely((int)255, (int)64, (int)81);
        this.addListener(9, e -> {
            GC gc = e.gc;
            gc.setFont(this.getFont());
            gc.setAdvanced(true);
            gc.setTextAntialias(1);
            gc.setAntialias(1);
            if (this.bottom) {
                this.drawSteps(4, gc);
                this.drawTexts(42, gc);
            } else {
                this.drawTexts(4, gc);
                this.drawSteps(30, gc);
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 3200;
        int newStyle = style & 0xC80;
        return newStyle |= 0x20000000;
    }

    private void drawSteps(int y, GC gc) {
        List<Point> textSizes = this.computeTextSizes();
        int leftSpacing = Math.max(4, textSizes.get((int)0).x / 2);
        int rightSpacing = Math.max(4, textSizes.get((int)(textSizes.size() - 1)).x / 2);
        int x = leftSpacing;
        int count = this.steps.size();
        int lineWidth = (this.getSize().x - x - rightSpacing - count * 24) / (count - 1);
        int i = 0;
        while (i < count) {
            int centerX;
            gc.setLineWidth(3);
            if (i < this.currentStep) {
                gc.setBackground(this.getForeground());
                gc.fillOval(x, y, 24, 24);
                gc.setForeground(this.getBackground());
                gc.setBackground(this.getForeground());
                gc.setLineWidth(2);
                centerX = 12;
                int centerY = 12;
                gc.drawLine(x + 6, y + 12, x + 9, y + 12 + 4);
                gc.drawLine(x + 9, y + 12 + 4, x + 12 + 6, y + 12 - 3);
            } else if (i == this.currentStep && this.onError) {
                gc.setBackground(this.errorColor);
                gc.fillOval(x, y, 24, 24);
                gc.setBackground(this.getDisplay().getSystemColor(1));
                centerX = x + 12;
                gc.fillRectangle(centerX - 2, y + 5, 4, 9);
                gc.fillRectangle(centerX - 2, y + 16, 4, 4);
            } else {
                if (i == this.currentStep) {
                    gc.setForeground(this.getForeground());
                } else {
                    gc.setForeground(this.unselectedColor);
                }
                gc.drawOval(x, y, 24, 24);
            }
            gc.setLineWidth(1);
            x += 24;
            if (i != count - 1) {
                int middleY = 10;
                if (i >= this.currentStep) {
                    gc.setBackground(this.unselectedColor);
                } else {
                    gc.setBackground(this.getForeground());
                }
                gc.fillRectangle(x + (i >= this.currentStep && !this.onError ? 2 : 0), y + 10, lineWidth, 4);
                x += lineWidth;
            }
            ++i;
        }
    }

    private void drawTexts(int y, GC gc) {
        List<Point> textSizes = this.computeTextSizes();
        int leftSpacing = Math.max(4, textSizes.get((int)0).x / 2);
        int rightSpacing = Math.max(4, textSizes.get((int)(textSizes.size() - 1)).x / 2);
        int x = leftSpacing;
        int count = this.steps.size();
        int lineWidth = (this.getSize().x - x - rightSpacing - count * 24) / (count - 1);
        gc.setForeground(this.textColor);
        gc.setBackground(this.getBackground());
        int i = 0;
        while (i < count) {
            gc.drawText(this.steps.get(i), x + 12 - textSizes.get((int)i).x / 2, y);
            x += 24 + lineWidth;
            ++i;
        }
    }

    public void addStep(String stepText) {
        this.checkWidget();
        if (stepText == null || stepText.trim().equals("")) {
            SWT.error((int)4);
        }
        this.steps.add(stepText);
        this.layout();
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int count = this.steps.size();
        int circleSizes = 24 * count;
        List<Point> textSizes = this.computeTextSizes();
        int width = circleSizes + 8;
        int height = 32;
        int maxHeightText = textSizes.size() == 0 ? 0 : textSizes.stream().max(Comparator.comparing((Function<Point, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(org.eclipse.swt.graphics.Point ), (Lorg/eclipse/swt/graphics/Point;)Ljava/lang/Integer;)())).get().y;
        width += textSizes.get((int)(textSizes.size() - 1)).x / 2;
        width += textSizes.get((int)0).x / 2;
        return new Point(Math.max(width += count - 80, wHint), Math.max(height += maxHeightText + 14, hHint));
    }

    private List<Point> computeTextSizes() {
        int count = this.steps.size();
        ArrayList<Point> list = new ArrayList<Point>(count);
        GC gc = new GC((Drawable)this);
        gc.setTextAntialias(1);
        gc.setFont(this.getFont());
        int i = 0;
        while (i < count) {
            Point textSize = gc.textExtent(this.steps.get(i), 1);
            list.add(textSize);
            ++i;
        }
        gc.dispose();
        return list;
    }

    public int getCurrentStep() {
        this.checkWidget();
        return this.currentStep;
    }

    public List<String> getSteps() {
        this.checkWidget();
        return this.steps;
    }

    public Color getTextColor() {
        this.checkWidget();
        return this.textColor;
    }

    public Color getUnselectedColor() {
        this.checkWidget();
        return this.unselectedColor;
    }

    public void removeStep(String stepText) {
        this.checkWidget();
        if (stepText == null || stepText.trim().equals("")) {
            SWT.error((int)4);
        }
        this.steps.remove(stepText);
        this.layout();
        this.redraw();
    }

    public void setCurrentStep(int currentStep) {
        this.checkWidget();
        if (currentStep < 0 || currentStep > this.steps.size() - 1) {
            SWT.error((int)6);
        }
        this.currentStep = currentStep;
        this.redraw();
    }

    public void setUnselectedColor(Color unselectedColor) {
        this.checkWidget();
        this.unselectedColor = unselectedColor;
        this.redraw();
    }

    public void setErrorState(boolean errorState) {
        this.checkWidget();
        this.onError = errorState;
        this.redraw();
    }

    public void setSteps(String[] steps) {
        this.checkWidget();
        if (steps == null) {
            SWT.error((int)4);
        }
        this.steps = Arrays.asList(steps);
        this.layout();
        this.redraw();
    }

    public void setSteps(List<String> steps) {
        this.checkWidget();
        if (steps == null) {
            SWT.error((int)4);
        }
        this.steps = steps;
        this.layout();
        this.redraw();
    }

    public void setTextColor(Color textColor) {
        this.checkWidget();
        this.textColor = textColor;
        this.redraw();
    }

    private static /* synthetic */ Integer lambda$1(Point p) {
        return p.x;
    }
}

