/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.nebulaslider;

import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.nebula.widgets.opal.nebulaslider.NebulaSliderGraphicConfiguration;
import org.eclipse.nebula.widgets.opal.nebulaslider.NebularSliderDefaultConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class NebulaSlider
extends Canvas {
    private NebulaSliderGraphicConfiguration renderer = new NebularSliderDefaultConfiguration(this);
    private int minimum = Integer.MIN_VALUE;
    private int maximum = Integer.MAX_VALUE;
    private int value = 0;
    private int xPosition = -1;
    private int mouseDeltaX;
    private boolean moving = false;

    public NebulaSlider(Composite parent, int style) {
        super(parent, NebulaSlider.checkStyle(style) | 0x20000000);
        this.addPaintListener(e -> this.paintControl(e.gc));
        this.addMouseListeners();
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            return style & 0xFFFFF7FF;
        }
        return 0;
    }

    private void paintControl(GC gc) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        if (this.xPosition < 0) {
            this.xPosition = this.computeXPosition();
        }
        this.drawBar(gc);
        this.drawSelectionPart(gc);
        this.drawSelector(gc);
    }

    private void drawBar(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.renderer.getBarBorderColor());
        gc.setBackground(this.renderer.getBarInsideColor());
        int hMargin = this.renderer.getHorizontalMargin();
        int selectorWidth = this.renderer.getSelectorWidth();
        int barHeight = this.renderer.getBarHeight();
        int x = hMargin + selectorWidth / 2;
        int y = (rect.height - barHeight) / 2;
        int width = rect.width - hMargin * 2 - selectorWidth;
        gc.fillRoundRectangle(x, y, width, barHeight, barHeight, barHeight);
        gc.drawRoundRectangle(x, y, width, barHeight, barHeight, barHeight);
    }

    private void drawSelectionPart(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.renderer.getBarBorderColor());
        gc.setBackground(this.renderer.getBarSelectionColor());
        int barHeight = this.renderer.getBarHeight();
        int x = this.renderer.getHorizontalMargin() + this.renderer.getSelectorWidth() / 2;
        int y = (rect.height - barHeight) / 2;
        gc.fillRoundRectangle(x, y, this.xPosition, barHeight, barHeight, barHeight);
        gc.drawRoundRectangle(x, y, this.xPosition, barHeight, barHeight, barHeight);
    }

    private int computeXPosition() {
        int originalWidth = this.getClientArea().width - this.renderer.getHorizontalMargin() * 2 - this.renderer.getSelectorWidth();
        float coeff = (float)this.value * 1.0f / (float)(this.maximum - this.minimum);
        int position = (int)(coeff * (float)originalWidth);
        return position;
    }

    private void drawSelector(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.renderer.getSelectorColorBorder());
        gc.setBackground(this.renderer.getSelectorColor());
        int hMargin = this.renderer.getHorizontalMargin();
        int selectorWidth = this.renderer.getSelectorWidth();
        int selectorHeight = this.renderer.getSelectorHeight();
        int y = (rect.height - selectorHeight) / 2;
        gc.fillRoundRectangle(hMargin + this.xPosition, y, selectorWidth, selectorHeight, selectorHeight, selectorHeight);
        gc.drawRoundRectangle(hMargin + this.xPosition, y, selectorWidth, selectorHeight, selectorHeight, selectorHeight);
        gc.setForeground(this.renderer.getArrowColor());
        gc.setLineWidth(this.renderer.getArrowLineWidth());
        int baseY = y + selectorHeight / 2;
        gc.drawLine(hMargin + this.xPosition + 10, baseY, hMargin + this.xPosition + 17, baseY - 7);
        gc.drawLine(hMargin + this.xPosition + 10, baseY, hMargin + this.xPosition + 17, baseY + 7);
        gc.drawLine(hMargin + this.xPosition + selectorWidth - 10, baseY, hMargin + this.xPosition + selectorWidth - 17, baseY - 7);
        gc.drawLine(hMargin + this.xPosition + selectorWidth - 10, baseY, hMargin + this.xPosition + selectorWidth - 17, baseY + 7);
        gc.setForeground(this.renderer.getSelectorTextColor());
        gc.setFont(this.renderer.getTextFont());
        String valueAsString = String.valueOf(this.value);
        Point textSize = gc.textExtent(valueAsString);
        int xText = hMargin + this.xPosition + selectorWidth / 2;
        int yText = y + selectorHeight / 2;
        gc.drawText(valueAsString, xText - textSize.x / 2, yText - textSize.y / 2, true);
    }

    private void addMouseListeners() {
        this.addListener(3, e -> {
            int selectorWidth = this.renderer.getSelectorWidth();
            int selectorHeight = this.renderer.getSelectorHeight();
            int y = (this.getClientArea().height - selectorHeight) / 2;
            Rectangle rect = new Rectangle(this.xPosition + this.renderer.getHorizontalMargin(), y, selectorWidth, selectorHeight);
            if (!rect.contains(e.x, e.y)) {
                return;
            }
            this.moving = true;
            this.mouseDeltaX = this.xPosition - e.x;
        });
        this.addListener(4, e -> {
            this.moving = false;
            this.mouseDeltaX = 0;
            this.redraw();
        });
        this.addListener(5, e -> {
            int originalWidth;
            if (!this.moving) {
                return;
            }
            this.xPosition = e.x + this.mouseDeltaX;
            if (this.xPosition < 0) {
                this.xPosition = 0;
            }
            if (this.xPosition > (originalWidth = this.getClientArea().width - this.renderer.getHorizontalMargin() * 2 - this.renderer.getSelectorWidth())) {
                this.xPosition = originalWidth;
            }
            float ratio = (float)this.xPosition / (float)originalWidth;
            this.value = (int)Math.floor(ratio * (float)(this.maximum - this.minimum));
            SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e);
            this.redraw();
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.addSelectionListener((Control)this, (SelectionListener)listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(Math.max(300, wHint), Math.max(40, hHint));
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.removeSelectionListener((Control)this, (SelectionListener)listener);
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.checkWidget();
        if (minimum > this.maximum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is greater than the maximum value (%d)", minimum, this.maximum)));
        }
        this.minimum = minimum;
        this.redraw();
        this.update();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        if (maximum < this.minimum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is lower than the minimum value (%d)", maximum, this.minimum)));
        }
        this.maximum = maximum;
        this.redraw();
        this.update();
    }

    public int getValue() {
        this.checkWidget();
        return this.value;
    }

    public void setValue(int value) {
        this.checkWidget();
        if (value < this.minimum || value > this.maximum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is not int the range [%d - %d]", value, this.minimum, this.maximum)));
        }
        this.value = value;
        this.xPosition = -1;
        this.redraw();
        this.update();
    }

    public NebulaSliderGraphicConfiguration getRenderer() {
        this.checkWidget();
        return this.renderer;
    }

    public void setRenderer(NebulaSliderGraphicConfiguration renderer) {
        this.checkWidget();
        this.renderer = renderer;
        this.redraw();
    }
}

