/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation.effects;

import org.eclipse.nebula.animation.AnimationRunner;
import org.eclipse.nebula.animation.effects.AbstractEffect;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class GrowEffect
extends AbstractEffect {
    Rectangle src;
    Rectangle dest;
    Rectangle diff;
    Control control = null;

    public void grow(AnimationRunner runner, Control w, int duration, IMovement movement, Runnable onStop, Runnable onCancel) {
        GrowEffect effect = new GrowEffect(w, w.getBounds(), new Rectangle(w.getBounds().x + 10, w.getBounds().y + 10, w.getBounds().width + 10, w.getBounds().height + 10), duration, movement, onStop, onCancel);
        runner.runEffect(effect);
    }

    public GrowEffect(Control control, Rectangle src, Rectangle dest, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.src = src;
        this.dest = dest;
        this.control = control;
        this.diff = new Rectangle(dest.x - src.x, dest.y - src.y, dest.width - src.width, dest.height - src.height);
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
    }

    @Override
    public void applyEffect(long currentTime) {
        if (!this.control.isDisposed()) {
            this.control.setBounds((int)((double)this.src.x - (double)this.diff.x * this.easingFunction.getValue(currentTime)), (int)((double)this.src.y - (double)this.diff.y * this.easingFunction.getValue(currentTime)), (int)((double)this.src.width + (double)(2 * this.diff.width) * this.easingFunction.getValue(currentTime)), (int)((double)this.src.height + (double)(2 * this.diff.height) * this.easingFunction.getValue(currentTime)));
        }
    }
}

