/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.text;

import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.nebula.paperclips.core.text.TextIterator;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class TextPrint
implements Print {
    public static final String DEFAULT_TEXT = "";
    public static final FontData DEFAULT_FONT_DATA = new FontData();
    public static final int DEFAULT_ALIGN = 16384;
    private static final TextStyle DEFAULT_STYLE = new TextStyle();
    String text;
    TextStyle style;
    boolean wordSplitting;

    public TextPrint() {
        this(DEFAULT_TEXT);
    }

    public TextPrint(String text) {
        this(text, DEFAULT_STYLE);
    }

    public TextPrint(String text, FontData fontData) {
        this(text, DEFAULT_STYLE.font(fontData));
    }

    public TextPrint(String text, int align) {
        this(text, DEFAULT_STYLE.align(align));
    }

    public TextPrint(String text, FontData fontData, int align) {
        this(text, DEFAULT_STYLE.font(fontData).align(align));
    }

    public TextPrint(String text, TextStyle style) {
        Util.notNull(text, style);
        this.text = text;
        this.style = style;
        this.wordSplitting = true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.wordSplitting ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextPrint other = (TextPrint)obj;
        if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return this.wordSplitting == other.wordSplitting;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        Util.notNull(text);
        this.text = text;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public void setStyle(TextStyle style) {
        Util.notNull(style);
        this.style = style;
    }

    public FontData getFontData() {
        return this.style.getFontData();
    }

    public void setFontData(FontData fontData) {
        this.setStyle(this.style.font(fontData));
    }

    public int getAlignment() {
        return this.style.getAlignment();
    }

    public void setAlignment(int alignment) {
        this.setStyle(this.style.align(alignment));
    }

    public RGB getForeground() {
        return this.style.getForeground();
    }

    public void setForeground(RGB foreground) {
        this.setStyle(this.style.foreground(foreground));
    }

    public RGB getBackground() {
        return this.style.getBackground();
    }

    public void setBackground(RGB background) {
        this.style = this.style.background(background);
    }

    public boolean getUnderline() {
        return this.style.getUnderline();
    }

    public void setUnderline(boolean underline) {
        this.style = this.style.underline(underline);
    }

    public boolean getStrikeout() {
        return this.style.getStrikeout();
    }

    public void setStrikeout(boolean strikeout) {
        this.style = this.style.strikeout(strikeout);
    }

    public boolean getWordSplitting() {
        return this.wordSplitting;
    }

    public void setWordSplitting(boolean wordBreaking) {
        this.wordSplitting = wordBreaking;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        return new TextIterator(this, device, gc);
    }
}

