/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.nebula.paperclips.core.text.LineBreakPrint;
import org.eclipse.nebula.paperclips.core.text.StyledTextIterator;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class StyledTextPrint
implements Print {
    private final List<Print> elements = new ArrayList<Print>();
    private TextStyle style = new TextStyle();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyledTextPrint other = (StyledTextPrint)obj;
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        return !(this.style == null ? other.style != null : !this.style.equals(other.style));
    }

    public StyledTextPrint setStyle(TextStyle style) {
        Util.notNull(style);
        this.style = style;
        return this;
    }

    public StyledTextPrint append(String text) {
        return this.append(text, this.style);
    }

    public StyledTextPrint append(String text, TextStyle style) {
        TextPrint textPrint = new TextPrint(text, style);
        textPrint.setWordSplitting(false);
        return this.append(textPrint);
    }

    public StyledTextPrint newline() {
        return this.append(new LineBreakPrint(this.style.getFontData()));
    }

    public StyledTextPrint append(Print element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        return new StyledTextIterator(this.elements.toArray(new Print[this.elements.size()]), device, gc);
    }
}

