/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.CompositeEntry;
import org.eclipse.nebula.paperclips.core.CompositePiece;
import org.eclipse.nebula.paperclips.core.Margins;
import org.eclipse.nebula.paperclips.core.NullPrintPiece;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.RotatePrint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

public class PageEnumeration {
    private PrintIterator document;
    private Rectangle marginBounds;
    private Rectangle paperBounds;
    private boolean hasNext;

    PageEnumeration(PrintJob job, Printer printer, GC gc) {
        job = PageEnumeration.applyOrientation(job, printer);
        Margins margins = job.getMargins();
        this.marginBounds = PaperClips.getMarginBounds(margins, printer);
        this.paperBounds = PaperClips.getPaperBounds(printer);
        this.document = job.getDocument().iterator((Device)printer, gc);
        this.hasNext = this.document.hasNext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public PrintPiece nextPage() {
        PrintPiece result;
        if (!this.hasNext) {
            return null;
        }
        PrintPiece page = PaperClips.next(this.document, this.marginBounds.width, this.marginBounds.height);
        this.hasNext = PageEnumeration.notNull(page) && PageEnumeration.notDebugPiece(page) && this.document.hasNext();
        PrintPiece printPiece = result = page == null ? null : this.createPagePiece(page);
        if (!this.hasNext) {
            this.document = null;
            this.marginBounds = null;
            this.paperBounds = null;
        }
        return result;
    }

    private PrintPiece createPagePiece(PrintPiece page) {
        Point offset = new Point(this.marginBounds.x - this.paperBounds.x, this.marginBounds.y - this.paperBounds.y);
        CompositeEntry entry = new CompositeEntry(page, offset);
        Point size = new Point(this.paperBounds.width, this.paperBounds.height);
        return new CompositePiece(new CompositeEntry[]{entry}, size);
    }

    private static boolean notNull(PrintPiece page) {
        return page != null;
    }

    private static boolean notDebugPiece(PrintPiece page) {
        return !PaperClips.debug || !(page instanceof NullPrintPiece);
    }

    private static PrintJob applyOrientation(PrintJob printJob, Printer printer) {
        int orientation = printJob.getOrientation();
        Rectangle paperBounds = PaperClips.getPaperBounds(printer);
        if (orientation == 256 && paperBounds.width < paperBounds.height || orientation == 512 && paperBounds.height < paperBounds.width) {
            String name = printJob.getName();
            RotatePrint document = new RotatePrint(printJob.getDocument());
            Margins margins = printJob.getMargins().rotate();
            printJob = new PrintJob(name, document).setMargins(margins).setOrientation(-1);
        }
        return printJob;
    }
}

