/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.AlignIterator;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class AlignPrint
implements Print {
    private static final int DEFAULT_HORIZONTAL_ALIGN = 16384;
    private static final int DEFAULT_VERTICAL_ALIGN = 128;
    final Print target;
    final int hAlign;
    final int vAlign;

    public AlignPrint(Print target, int hAlign, int vAlign) {
        Util.notNull(target);
        this.target = target;
        this.hAlign = AlignPrint.checkHAlign(hAlign);
        this.vAlign = AlignPrint.checkVAlign(vAlign);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hAlign;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + this.vAlign;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlignPrint other = (AlignPrint)obj;
        if (this.hAlign != other.hAlign) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        return this.vAlign == other.vAlign;
    }

    public Print getTarget() {
        return this.target;
    }

    public Point getAlignment() {
        return new Point(this.hAlign, this.vAlign);
    }

    private static int checkHAlign(int hAlign) {
        if (hAlign == 16384 || hAlign == 0x1000000 || hAlign == 131072) {
            return hAlign;
        }
        if (hAlign == -1) {
            return 16384;
        }
        PaperClips.error(5, "hAlign must be one of SWT.LEFT, SWT.CENTER or SWT.RIGHT");
        return hAlign;
    }

    private static int checkVAlign(int vAlign) {
        if (vAlign == 128 || vAlign == 0x1000000 || vAlign == 1024) {
            return vAlign;
        }
        if (vAlign == -1) {
            return 128;
        }
        PaperClips.error(5, "vAlign must be one of SWT.TOP, SWT.CENTER or SWT.BOTTOM");
        return vAlign;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        return new AlignIterator(this, device, gc);
    }
}

