/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.tiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.nebula.widgets.tiles.DecoratorColor;
import org.eclipse.nebula.widgets.tiles.DecoratorColorConstant;
import org.eclipse.nebula.widgets.tiles.DecoratorInteger;
import org.eclipse.nebula.widgets.tiles.DecoratorIntegerConstant;
import org.eclipse.nebula.widgets.tiles.DecoratorString;
import org.eclipse.nebula.widgets.tiles.DecoratorStringToString;
import org.eclipse.nebula.widgets.tiles.Filter;
import org.eclipse.nebula.widgets.tiles.Frame;
import org.eclipse.nebula.widgets.tiles.Tile;
import org.eclipse.nebula.widgets.tiles.Tiles;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;

class FrameStatic<T>
extends Frame<T>
implements Cloneable {
    private List<T> elements = new ArrayList<T>();
    private Filter<T> filter;
    private Comparator<T> comparator;
    private final List<Tile<T>> rendered = new ArrayList<Tile<T>>();
    private Color background;
    private int width = 0;
    private int height = 0;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private int tileMarginX = 0;
    private int tileMarginY = 0;
    private DecoratorInteger<T> lineWidthDecorator;
    private DecoratorInteger<T> lineStyleDecorator;
    private DecoratorColor<T> foregroundColorDecorator;
    private DecoratorColor<T> backgroundColorDecorator;
    private DecoratorColor<T> lineColorDecorator;
    private DecoratorString<T> labelDecorator;
    private final Tiles<T> tiles;

    FrameStatic(List<T> elements, Filter<T> filter, Comparator<T> Comparator2, Color background, int width, int height, int tileWidth, int tileHeight, int tileMarginX, int tileMarginY, DecoratorInteger<T> lineWidthDecorator, DecoratorInteger<T> lineStyleDecorator, DecoratorColor<T> foregroundColorDecorator, DecoratorColor<T> backgroundColorDecorator, DecoratorColor<T> lineColorDecorator, DecoratorString<T> labelDecorator, Tiles<T> tiles) {
        super(tiles);
        this.elements = elements;
        this.filter = filter;
        this.comparator = Comparator2;
        this.background = background;
        this.width = width;
        this.height = height;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.tileMarginX = tileMarginX;
        this.tileMarginY = tileMarginY;
        this.lineWidthDecorator = lineWidthDecorator;
        this.lineStyleDecorator = lineStyleDecorator;
        this.foregroundColorDecorator = foregroundColorDecorator;
        this.backgroundColorDecorator = backgroundColorDecorator;
        this.lineColorDecorator = lineColorDecorator;
        this.labelDecorator = labelDecorator;
        this.tiles = tiles;
        this.lineWidthDecorator.use();
        this.lineStyleDecorator.use();
        this.foregroundColorDecorator.use();
        this.backgroundColorDecorator.use();
        this.lineColorDecorator.use();
        this.labelDecorator.use();
    }

    FrameStatic(Tiles<T> tiles) {
        super(tiles);
        this.tiles = tiles;
        Color backgroundColor = new Color((Device)tiles.getDisplay(), 255, 255, 255);
        Color lineColor = new Color((Device)tiles.getDisplay(), 0, 0, 0);
        Color foregroundColor = new Color((Device)tiles.getDisplay(), 0, 0, 0);
        this.background = tiles.getBackground();
        this.lineWidthDecorator = new DecoratorIntegerConstant(1);
        this.lineStyleDecorator = new DecoratorIntegerConstant(1);
        this.foregroundColorDecorator = new DecoratorColorConstant(foregroundColor);
        this.foregroundColorDecorator.addDecoratorListener(() -> foregroundColor.dispose());
        this.backgroundColorDecorator = new DecoratorColorConstant(backgroundColor);
        this.backgroundColorDecorator.addDecoratorListener(() -> backgroundColor.dispose());
        this.lineColorDecorator = new DecoratorColorConstant(lineColor);
        this.lineColorDecorator.addDecoratorListener(() -> lineColor.dispose());
        this.labelDecorator = new DecoratorStringToString();
        this.filter = t -> true;
        this.comparator = (t1, t2) -> 0;
        Point p = tiles.getSize();
        this.width = p.x;
        this.height = p.y;
        this.lineWidthDecorator.use();
        this.lineStyleDecorator.use();
        this.foregroundColorDecorator.use();
        this.backgroundColorDecorator.use();
        this.lineColorDecorator.use();
        this.labelDecorator.use();
    }

    public FrameStatic<T> clone() {
        return new FrameStatic<T>(this.elements, this.filter, this.comparator, this.background, this.width, this.height, this.tileWidth, this.tileHeight, this.tileMarginX, this.tileMarginY, this.lineWidthDecorator, this.lineStyleDecorator, this.foregroundColorDecorator, this.backgroundColorDecorator, this.lineColorDecorator, this.labelDecorator, this.tiles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrameStatic other = (FrameStatic)obj;
        if (!Objects.equals(this.background, other.background)) {
            return false;
        }
        if (!Objects.equals(this.backgroundColorDecorator, other.backgroundColorDecorator)) {
            return false;
        }
        if (!Objects.equals(this.comparator, other.comparator)) {
            return false;
        }
        if (!Objects.equals(this.elements, other.elements)) {
            return false;
        }
        if (!Objects.equals(this.filter, other.filter)) {
            return false;
        }
        if (!Objects.equals(this.foregroundColorDecorator, other.foregroundColorDecorator)) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (!Objects.equals(this.labelDecorator, other.labelDecorator)) {
            return false;
        }
        if (!Objects.equals(this.lineColorDecorator, other.lineColorDecorator)) {
            return false;
        }
        if (!Objects.equals(this.lineStyleDecorator, other.lineStyleDecorator)) {
            return false;
        }
        if (!Objects.equals(this.lineWidthDecorator, other.lineWidthDecorator)) {
            return false;
        }
        if (this.tileHeight != other.tileHeight) {
            return false;
        }
        if (this.tileMarginX != other.tileMarginX) {
            return false;
        }
        if (this.tileMarginY != other.tileMarginY) {
            return false;
        }
        if (this.tileWidth != other.tileWidth) {
            return false;
        }
        if (!Objects.equals(this.tiles, other.tiles)) {
            return false;
        }
        return this.width == other.width;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.background, this.backgroundColorDecorator, this.comparator, this.elements, this.filter, this.foregroundColorDecorator, this.height, this.labelDecorator, this.lineColorDecorator, this.lineStyleDecorator, this.lineWidthDecorator, this.tileHeight, this.tileMarginX, this.tileMarginY, this.tileWidth, this.tiles, this.width});
    }

    public String toString() {
        return "FrameStatic [elements=" + this.elements + ", filter=" + this.filter + ", comparator=" + this.comparator + ", background=" + this.background + ", width=" + this.width + ", height=" + this.height + ", tileWidth=" + this.tileWidth + ", tileHeight=" + this.tileHeight + ", tileMarginX=" + this.tileMarginX + ", tileMarginY=" + this.tileMarginY + ", lineWidthDecorator=" + this.lineWidthDecorator + ", lineStyleDecorator=" + this.lineStyleDecorator + ", foregroundColorDecorator=" + this.foregroundColorDecorator + ", backgroundColorDecorator=" + this.backgroundColorDecorator + ", lineColorDecorator=" + this.lineColorDecorator + ", labelDecorator=" + this.labelDecorator + ", tiles=" + this.tiles + "]";
    }

    @Override
    protected void dispose() {
        this.lineWidthDecorator.free();
        this.lineStyleDecorator.free();
        this.foregroundColorDecorator.free();
        this.backgroundColorDecorator.free();
        this.lineColorDecorator.free();
        this.labelDecorator.free();
    }

    @Override
    protected Color getBackground() {
        return this.background;
    }

    @Override
    protected Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    protected DecoratorColor<T> getDecoratorBackgroundColor() {
        return this.backgroundColorDecorator;
    }

    @Override
    protected DecoratorColor<T> getDecoratorForegroundColor() {
        return this.foregroundColorDecorator;
    }

    @Override
    protected DecoratorString<T> getDecoratorLabel() {
        return this.labelDecorator;
    }

    @Override
    protected DecoratorColor<T> getDecoratorLineColor() {
        return this.lineColorDecorator;
    }

    @Override
    protected DecoratorInteger<T> getDecoratorLineStyle() {
        return this.lineStyleDecorator;
    }

    @Override
    protected DecoratorInteger<T> getDecoratorLineWidth() {
        return this.lineWidthDecorator;
    }

    @Override
    protected Filter<T> getFilter() {
        return this.filter;
    }

    @Override
    protected List<T> getItems() {
        return new ArrayList<T>(this.elements);
    }

    protected int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    protected List<Tile<T>> getTiles() {
        return this.rendered;
    }

    protected int getTileWidth() {
        return this.tileWidth;
    }

    protected void setBackground(Color arg0) {
        this.background = arg0;
    }

    protected void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    protected void setDecoratorBackgroundColor(DecoratorColor<T> decorator) {
        this.backgroundColorDecorator.free();
        this.backgroundColorDecorator = decorator;
        this.backgroundColorDecorator.use();
    }

    protected void setDecoratorForegroundColor(DecoratorColor<T> decorator) {
        this.foregroundColorDecorator.free();
        this.foregroundColorDecorator = decorator;
        this.foregroundColorDecorator.use();
    }

    protected void setDecoratorLabel(DecoratorString<T> decorator) {
        this.labelDecorator.free();
        this.labelDecorator = decorator;
        this.labelDecorator.use();
    }

    protected void setDecoratorLineColor(DecoratorColor<T> decorator) {
        this.lineColorDecorator.free();
        this.lineColorDecorator = decorator;
        this.lineColorDecorator.use();
    }

    protected void setDecoratorLineStyle(DecoratorInteger<T> decorator) {
        this.lineStyleDecorator.free();
        this.lineStyleDecorator = decorator;
        this.lineStyleDecorator.use();
    }

    protected void setDecoratorLineWidth(DecoratorInteger<T> decorator) {
        this.lineWidthDecorator.free();
        this.lineWidthDecorator = decorator;
        this.lineWidthDecorator.use();
    }

    protected void setFilter(Filter<T> filter) {
        this.filter = filter;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected void setItems(List<T> items) {
        this.elements.clear();
        this.elements.addAll(items);
    }

    protected void setTileHeight(int height) {
        this.tileHeight = height;
    }

    protected void setTileMarginX(int margin) {
        this.tileMarginX = margin;
    }

    protected void setTileMarginY(int margin) {
        this.tileMarginY = margin;
    }

    protected void setTileWidth(int width) {
        this.tileWidth = width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    @Override
    protected void update() {
        this.rendered.clear();
        int x = this.tileMarginX;
        int y = this.tileMarginY;
        ArrayList<T> active = new ArrayList<T>();
        for (Object element : this.elements) {
            if (!this.filter.accepts(element)) continue;
            active.add(element);
        }
        Collections.sort(active, this.comparator);
        for (Object element : active) {
            int lineWidth = (Integer)this.lineWidthDecorator.decorate(element);
            int lineStyle = (Integer)this.lineStyleDecorator.decorate(element);
            Color lineColor = (Color)this.lineColorDecorator.decorate(element);
            Color foregroundColor = (Color)this.foregroundColorDecorator.decorate(element);
            Color backgroundColor = (Color)this.backgroundColorDecorator.decorate(element);
            String label = (String)this.labelDecorator.decorate(element);
            this.rendered.add(new Tile<T>(element, x, y, this.tileWidth, this.tileHeight, label, lineWidth, lineStyle, lineColor, foregroundColor, backgroundColor));
            if ((x += this.tileWidth + this.tileMarginX) + this.tileWidth + this.tileMarginX > this.width) {
                y += this.tileHeight + this.tileMarginY;
                x = this.tileMarginX;
            }
            if (y + this.tileHeight + this.tileMarginY > this.height) break;
        }
    }
}

