/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.reorder.action.RowReorderDragMode;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class RowHeaderReorderDragMode
extends RowReorderDragMode {
    private final RowGroupHeaderLayer rowGroupHeaderLayer;
    protected int dragFromGridColumnPosition;

    public RowHeaderReorderDragMode(RowGroupHeaderLayer rowGroupHeaderLayer) {
        this.rowGroupHeaderLayer = rowGroupHeaderLayer;
    }

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        super.mouseDown(natTable, event);
        ILayerCell cell = natTable.getCellByPosition(natTable.getColumnPositionByX(this.initialEvent.x), natTable.getRowPositionByY(this.initialEvent.y));
        this.dragFromGridColumnPosition = cell != null ? cell.getOriginColumnPosition() + cell.getColumnSpan() - 1 : -1;
    }

    @Override
    public boolean isValidTargetRowPosition(ILayer natLayer, int fromGridRowPosition, int toGridRowPosition) {
        if (this.currentEvent != null) {
            CellEdgeEnum moveDirection = this.getMoveDirection(this.currentEvent.y);
            toGridRowPosition = this.getDragToGridRowPosition(moveDirection, this.natTable.getRowPositionByY(this.currentEvent.y));
        }
        int toPosition = LayerUtil.convertRowPosition(natLayer, toGridRowPosition, this.rowGroupHeaderLayer.getPositionLayer());
        int fromPosition = this.rowGroupHeaderLayer.getReorderFromRowPosition();
        int level = 0;
        while (level < this.rowGroupHeaderLayer.getLevelCount()) {
            if (!this.isValidTargetRowPosition(natLayer, fromGridRowPosition, toGridRowPosition, level, fromPosition, toPosition)) {
                return false;
            }
            ++level;
        }
        return true;
    }

    protected boolean isValidTargetRowPosition(ILayer natLayer, int fromGridRowPosition, int toGridRowPosition, int level, int fromPosition, int toPosition) {
        GroupModel model = this.rowGroupHeaderLayer.getGroupModel(level);
        if (model.isPartOfAnUnbreakableGroup(fromPosition) && model.getGroupByPosition(fromPosition).getOriginalSpan() > 1) {
            SelectionLayer.MoveDirectionEnum moveDirection;
            int toCheck = toPosition;
            toCheck = toPosition < 0 && toGridRowPosition == natLayer.getColumnCount() ? LayerUtil.convertRowPosition(natLayer, toGridRowPosition - 1, this.rowGroupHeaderLayer.getPositionLayer()) : (SelectionLayer.MoveDirectionEnum.DOWN == (moveDirection = PositionUtil.getVerticalMoveDirection(fromPosition, toCheck)) ? toCheck - 1 : toCheck);
            return RowGroupUtils.isInTheSameGroup(this.rowGroupHeaderLayer, level, fromPosition, toCheck);
        }
        boolean betweenTwoGroups = false;
        if (this.currentEvent != null) {
            int minX = this.currentEvent.x - 4;
            int maxX = this.currentEvent.x + 4;
            betweenTwoGroups = RowGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.rowGroupHeaderLayer, level);
        }
        return betweenTwoGroups || !model.isPartOfAnUnbreakableGroup(toPosition);
    }

    @Override
    protected CellEdgeEnum getMoveDirection(int y) {
        ILayerCell cell = this.getRowCell(y);
        if (cell != null) {
            Rectangle selectedRowHeaderRect = cell.getBounds();
            return CellEdgeDetectUtil.getVerticalCellEdge(selectedRowHeaderRect, new Point(this.natTable.getStartXOfColumnPosition(this.dragFromGridColumnPosition), y));
        }
        return null;
    }

    @Override
    protected ILayerCell getRowCell(int y) {
        int gridRowPosition = this.natTable.getRowPositionByY(y);
        return this.natTable.getCellByPosition(this.dragFromGridColumnPosition, gridRowPosition);
    }
}

