/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import junit.framework.TestCase;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;

public class AttachmentUtilTest
extends TestCase {
    TaskAttachment attachment = TaskTestUtil.createMockTaskAttachment("id");

    public void testGetAttachmentFilenameNull() {
        try {
            AttachmentUtil.getAttachmentFilename(null);
            AttachmentUtilTest.fail((String)"Expected AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    public void testGetAttachmentFilename() {
        this.attachment.setFileName("file.bmp");
        AttachmentUtilTest.assertEquals((String)"file.bmp", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameNoExtension() {
        this.attachment.setFileName("file");
        AttachmentUtilTest.assertEquals((String)"file", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmpty() {
        this.attachment.setFileName("");
        AttachmentUtilTest.assertEquals((String)"attachment", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeHtml() {
        this.attachment.setFileName("");
        this.attachment.setContentType("html");
        AttachmentUtilTest.assertEquals((String)"attachment.html", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeText() {
        this.attachment.setFileName("");
        this.attachment.setContentType("text");
        AttachmentUtilTest.assertEquals((String)"attachment.txt", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeZip() {
        this.attachment.setFileName("");
        this.attachment.setContentType("zip");
        AttachmentUtilTest.assertEquals((String)"attachment.zip", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeOctetStream() {
        this.attachment.setFileName("");
        this.attachment.setContentType("octet-stream");
        AttachmentUtilTest.assertEquals((String)"attachment", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeApplicationOctetStream() {
        this.attachment.setFileName("");
        this.attachment.setContentType("application/octet-stream");
        AttachmentUtilTest.assertEquals((String)"attachment.octet-stream", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeImagePng() {
        this.attachment.setFileName("");
        this.attachment.setContentType("image/png");
        AttachmentUtilTest.assertEquals((String)"attachment.png", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeImageJpeg() {
        this.attachment.setFileName("");
        this.attachment.setContentType("image/jpeg");
        AttachmentUtilTest.assertEquals((String)"attachment.jpeg", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeImageGif() {
        this.attachment.setFileName("");
        this.attachment.setContentType("image/gif");
        AttachmentUtilTest.assertEquals((String)"attachment.gif", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeTextPlain() {
        this.attachment.setFileName("");
        this.attachment.setContentType("text/plain");
        AttachmentUtilTest.assertEquals((String)"attachment.txt", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeTextHtml() {
        this.attachment.setFileName("");
        this.attachment.setContentType("text/html");
        AttachmentUtilTest.assertEquals((String)"attachment.html", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameEmptyContentTypeApplicationXml() {
        this.attachment.setFileName("");
        this.attachment.setContentType("application/xml");
        AttachmentUtilTest.assertEquals((String)"attachment.xml", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentFilenameTestHtmlContentTypeOctetStream() {
        this.attachment.setFileName("Test.html");
        this.attachment.setContentType("octet-stream");
        AttachmentUtilTest.assertEquals((String)"Test.html", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }

    public void testGetAttachmentIlegalFilename() {
        this.attachment.setFileName("Ilegal:File:Name");
        this.attachment.setContentType("octet-stream");
        AttachmentUtilTest.assertEquals((String)"Ilegal%3AFile%3AName", (String)AttachmentUtil.getAttachmentFilename((ITaskAttachment)this.attachment));
    }
}

