/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util.junit4;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.DumpThreadTask;
import org.eclipse.mylyn.commons.sdk.util.junit4.JUnitExecutionListener;

public class ManagedTestSuite
extends TestSuite {
    public static final long DELAY = 600000L;
    private final Listener listener = new Listener();

    public ManagedTestSuite() {
    }

    public ManagedTestSuite(String name) {
        super(name);
    }

    public void run(TestResult result) {
        if (JUnitExecutionListener.getDefault() == null) {
            result.addListener((TestListener)this.listener);
        }
        CommonTestUtil.fixProxyConfiguration();
        CommonTestUtil.dumpSystemInfo((PrintStream)System.err);
        super.run(result);
        if (JUnitExecutionListener.getDefault() == null) {
            this.listener.dumpResults(result);
            this.listener.startTest(new Test(){

                public int countTestCases() {
                    return 1;
                }

                public void run(TestResult result) {
                }

                public String toString() {
                    return "ShutdownWatchdog";
                }
            }, true);
        }
    }

    private static class Listener
    implements TestListener {
        private final ConcurrentHashMap<Test, DumpThreadTask> taskByTest = new ConcurrentHashMap();
        private final Timer timer = new Timer(true);

        private Listener() {
        }

        public void addError(Test test, Throwable t) {
            System.err.println("[ERROR]");
        }

        public void addFailure(Test test, AssertionFailedError t) {
            System.err.println("[FAILURE]");
        }

        private void dumpList(String header, Enumeration<TestFailure> failures) {
            System.err.println(header);
            while (failures.hasMoreElements()) {
                TestFailure failure = failures.nextElement();
                System.err.print("  ");
                System.err.println(failure.toString());
            }
        }

        public void dumpResults(TestResult result) {
            if (result.failureCount() > 0) {
                System.err.println();
                this.dumpList("Failures: ", result.failures());
            }
            if (result.errorCount() > 0) {
                System.err.println();
                this.dumpList("Errors: ", result.errors());
            }
            int failedCount = result.errorCount() + result.failureCount();
            System.err.println();
            System.err.println(MessageFormat.format("{0} out of {1} tests failed", failedCount, result.runCount()));
        }

        public void endTest(Test test) {
            DumpThreadTask task = this.taskByTest.remove(test);
            if (task != null) {
                task.cancel();
            }
            Thread.interrupted();
        }

        public void startTest(Test test) {
            this.startTest(test, false);
        }

        public void startTest(Test test, boolean silent) {
            if (!silent) {
                System.err.println("Running " + test.toString());
            }
            DumpThreadTask task = new DumpThreadTask(test.toString());
            this.taskByTest.put(test, task);
            this.timer.schedule((TimerTask)task, 600000L);
        }
    }
}

