/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util.junit4;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import org.eclipse.mylyn.commons.sdk.util.AbstractTestFixture;
import org.eclipse.mylyn.commons.sdk.util.junit4.IFixtureJUnitClass;
import org.eclipse.mylyn.commons.sdk.util.junit4.IgnoreStatement;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConditionalIgnoreRule
implements TestRule {
    private final IFixtureJUnitClass fixtureJUnitClass;

    public ConditionalIgnoreRule(IFixtureJUnitClass fixtureJUnitClass) {
        this.fixtureJUnitClass = fixtureJUnitClass;
    }

    public Statement apply(Statement aStatement, Description aDescription) {
        IgnoreCondition condition;
        Statement result = aStatement;
        if (ConditionalIgnoreRule.hasConditionalIgnoreAnnotation(aDescription) && (condition = ConditionalIgnoreRule.getIgnoreCondition(aDescription)).isSatisfied(this.fixtureJUnitClass.getActualFixture())) {
            result = new IgnoreStatement();
        }
        return result;
    }

    private static boolean hasConditionalIgnoreAnnotation(Description aDescription) {
        return aDescription.getAnnotation(ConditionalIgnore.class) != null;
    }

    private static IgnoreCondition getIgnoreCondition(Description aDescription) {
        ConditionalIgnore annotation = (ConditionalIgnore)aDescription.getAnnotation(ConditionalIgnore.class);
        return new IgnoreConditionCreator(aDescription.getTestClass(), annotation).create();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ConditionalIgnore {
        public Class<? extends IgnoreCondition> condition();
    }

    public static interface IgnoreCondition {
        public boolean isSatisfied(AbstractTestFixture var1);
    }

    private static class IgnoreConditionCreator {
        private final Class<?> testClass;
        private final Class<? extends IgnoreCondition> conditionType;

        IgnoreConditionCreator(Class<?> testClass, ConditionalIgnore annotation) {
            this.testClass = testClass;
            this.conditionType = annotation.condition();
        }

        IgnoreCondition create() {
            this.checkConditionType();
            try {
                return this.createCondition();
            }
            catch (Exception re) {
                throw new RuntimeException(re);
            }
        }

        private IgnoreCondition createCondition() throws Exception {
            IgnoreCondition result = this.isConditionTypeStandalone() ? this.conditionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : this.conditionType.getDeclaredConstructor(this.testClass).newInstance(this.testClass);
            return result;
        }

        private void checkConditionType() {
            if (!this.isConditionTypeStandalone() && !this.isConditionTypeDeclaredInTarget()) {
                String msg = "Conditional class '%s' is a member class but was not declared inside the test case using it.\nEither make this class a static class, standalone class (by declaring it in it's own file) or move it inside the test case using it";
                throw new IllegalArgumentException(String.format(msg, this.conditionType.getName()));
            }
        }

        private boolean isConditionTypeStandalone() {
            return !this.conditionType.isMemberClass() || Modifier.isStatic(this.conditionType.getModifiers());
        }

        private boolean isConditionTypeDeclaredInTarget() {
            return this.testClass.getClass().isAssignableFrom(this.conditionType.getDeclaringClass());
        }
    }
}

