/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonLogRecordServerUtil {
    private static Logger logger = Logger.getLogger(JsonLogRecordServerUtil.class.getName());

    public static LogRecord logRecordFromJson(String jsonString) throws JSONException {
        JSONObject lro = new JSONObject(jsonString);
        String level = lro.getString("level");
        String loggerName = lro.getString("loggerName");
        String msg = lro.getString("msg");
        long timestamp = Long.parseLong(lro.getString("timestamp"));
        Throwable thrown = JsonLogRecordServerUtil.throwableFromJson(lro.getString("thrown"));
        LogRecord lr = new LogRecord(Level.parse(level), msg);
        lr.setLoggerName(loggerName);
        lr.setThrown(thrown);
        lr.setMillis(timestamp);
        return lr;
    }

    private static StackTraceElement stackTraceElementFromJson(String jsonString) throws JSONException {
        JSONObject ste = new JSONObject(jsonString);
        String className = ste.getString("className");
        String fileName = ste.getString("fileName");
        String methodName = ste.getString("methodName");
        int lineNumber = Integer.parseInt(ste.getString("lineNumber"));
        return new StackTraceElement(className, methodName, fileName, lineNumber);
    }

    private static Throwable throwableFromJson(String jsonString) throws JSONException {
        if (jsonString.equals("{}")) {
            return null;
        }
        JSONObject t = new JSONObject(jsonString);
        String message = t.getString("message");
        Throwable cause = JsonLogRecordServerUtil.throwableFromJson(t.getString("cause"));
        StackTraceElement[] stackTrace = null;
        JSONArray st = t.getJSONArray("stackTrace");
        if (st.length() > 0) {
            stackTrace = new StackTraceElement[st.length()];
            for (int i = 0; i < st.length(); ++i) {
                stackTrace[i] = JsonLogRecordServerUtil.stackTraceElementFromJson(st.getString(i));
            }
        }
        Throwable thrown = new Throwable(message, cause);
        thrown.setStackTrace(stackTrace);
        return thrown;
    }
}

