/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui.editor;

import junit.framework.TestCase;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryCompletionProcessor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.ui.MockTextViewer;
import org.eclipse.swt.graphics.Point;

public class RepositoryCompletionProcessorTest
extends TestCase {
    private TaskRepository repository;

    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        this.repository = TaskTestUtil.createMockRepository();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
    }

    public void testComputeCompletionProposals() {
        TaskTask taskFoo = this.addTask("1", "foo");
        TaskTask taskBar = this.addTask("2", "bar");
        RepositoryCompletionProcessor processor = new RepositoryCompletionProcessor(this.repository);
        ICompletionProposal[] proposals = processor.computeCompletionProposals((ITextViewer)new MockTextViewer(""), 0);
        RepositoryCompletionProcessorTest.assertEquals((int)2, (int)proposals.length);
        RepositoryCompletionProcessorTest.assertEquals((Object)taskFoo, (Object)((RepositoryCompletionProcessor.TaskCompletionProposal)proposals[0]).getTask());
        RepositoryCompletionProcessorTest.assertEquals((Object)taskBar, (Object)((RepositoryCompletionProcessor.TaskCompletionProposal)proposals[1]).getTask());
        proposals = processor.computeCompletionProposals((ITextViewer)new MockTextViewer("abc"), 1);
        RepositoryCompletionProcessorTest.assertEquals((int)0, (int)proposals.length);
    }

    public void testComputeCompletionProposalsPrefix() {
        TaskTask taskFoo = this.addTask("1", "foo");
        TaskTask taskBar = this.addTask("2", "bar");
        RepositoryCompletionProcessor processor = new RepositoryCompletionProcessor(this.repository);
        MockTextViewer viewer = new MockTextViewer("task");
        ICompletionProposal[] proposals = processor.computeCompletionProposals((ITextViewer)viewer, 4);
        RepositoryCompletionProcessorTest.assertEquals((int)2, (int)proposals.length);
        RepositoryCompletionProcessor.TaskCompletionProposal proposal = (RepositoryCompletionProcessor.TaskCompletionProposal)proposals[0];
        RepositoryCompletionProcessorTest.assertEquals((Object)taskFoo, (Object)proposal.getTask());
        RepositoryCompletionProcessorTest.assertEquals((Object)taskBar, (Object)((RepositoryCompletionProcessor.TaskCompletionProposal)proposals[1]).getTask());
        RepositoryCompletionProcessorTest.assertEquals((String)"task 1", (String)proposal.getReplacement());
        IDocument doc = viewer.getDocument();
        proposal.apply(doc);
        RepositoryCompletionProcessorTest.assertEquals((String)"task 1", (String)doc.get());
        RepositoryCompletionProcessorTest.assertEquals((Object)new Point(6, 0), (Object)proposal.getSelection(doc));
    }

    public void testComputeCompletionProposalsPrefixSpace() {
        TaskTask taskFoo = this.addTask("1", "foo");
        TaskTask taskBar = this.addTask("2", "bar");
        RepositoryCompletionProcessor processor = new RepositoryCompletionProcessor(this.repository);
        MockTextViewer viewer = new MockTextViewer("task ");
        ICompletionProposal[] proposals = processor.computeCompletionProposals((ITextViewer)viewer, 5);
        RepositoryCompletionProcessorTest.assertEquals((int)2, (int)proposals.length);
        RepositoryCompletionProcessor.TaskCompletionProposal proposal = (RepositoryCompletionProcessor.TaskCompletionProposal)proposals[0];
        RepositoryCompletionProcessorTest.assertEquals((Object)taskFoo, (Object)proposal.getTask());
        RepositoryCompletionProcessorTest.assertEquals((Object)taskBar, (Object)((RepositoryCompletionProcessor.TaskCompletionProposal)proposals[1]).getTask());
        RepositoryCompletionProcessorTest.assertEquals((String)"task 1", (String)proposal.getReplacement());
        IDocument doc = viewer.getDocument();
        proposal.apply(doc);
        RepositoryCompletionProcessorTest.assertEquals((String)"task 1", (String)doc.get());
        RepositoryCompletionProcessorTest.assertEquals((Object)new Point(6, 0), (Object)proposal.getSelection(doc));
    }

    public void testComputeCompletionProposalsParenthesis() {
        TaskTask taskFoo = this.addTask("1", "foo");
        TaskTask taskBar = this.addTask("2", "bar");
        RepositoryCompletionProcessor processor = new RepositoryCompletionProcessor(this.repository);
        MockTextViewer viewer = new MockTextViewer("(task");
        ICompletionProposal[] proposals = processor.computeCompletionProposals((ITextViewer)viewer, 5);
        RepositoryCompletionProcessorTest.assertEquals((int)2, (int)proposals.length);
        RepositoryCompletionProcessor.TaskCompletionProposal proposal = (RepositoryCompletionProcessor.TaskCompletionProposal)proposals[0];
        RepositoryCompletionProcessorTest.assertEquals((Object)taskFoo, (Object)proposal.getTask());
        RepositoryCompletionProcessorTest.assertEquals((Object)taskBar, (Object)((RepositoryCompletionProcessor.TaskCompletionProposal)proposals[1]).getTask());
        RepositoryCompletionProcessorTest.assertEquals((String)"task 1", (String)proposal.getReplacement());
        IDocument doc = viewer.getDocument();
        proposal.apply(doc);
        RepositoryCompletionProcessorTest.assertEquals((String)"(task 1", (String)doc.get());
        RepositoryCompletionProcessorTest.assertEquals((Object)new Point(7, 0), (Object)proposal.getSelection(doc));
    }

    public void testComputeCompletionProposalsStar() {
        TaskTask task1 = this.addTask("1", "mylyn foo");
        TaskTask task2 = this.addTask("2", "mylyn bar");
        RepositoryCompletionProcessor processor = new RepositoryCompletionProcessor(this.repository);
        MockTextViewer viewer = new MockTextViewer("my*foo");
        ICompletionProposal[] proposals = processor.computeCompletionProposals((ITextViewer)viewer, 6);
        RepositoryCompletionProcessorTest.assertEquals((int)1, (int)proposals.length);
        RepositoryCompletionProcessor.TaskCompletionProposal proposal = (RepositoryCompletionProcessor.TaskCompletionProposal)proposals[0];
        RepositoryCompletionProcessorTest.assertEquals((Object)task1, (Object)proposal.getTask());
        IDocument doc = viewer.getDocument();
        proposal.apply(doc);
        RepositoryCompletionProcessorTest.assertEquals((String)"task 1", (String)doc.get());
        RepositoryCompletionProcessorTest.assertEquals((Object)new Point(6, 0), (Object)proposal.getSelection(doc));
        viewer = new MockTextViewer("my*bar");
        proposals = processor.computeCompletionProposals((ITextViewer)viewer, 6);
        RepositoryCompletionProcessorTest.assertEquals((int)1, (int)proposals.length);
        proposal = (RepositoryCompletionProcessor.TaskCompletionProposal)proposals[0];
        RepositoryCompletionProcessorTest.assertEquals((Object)task2, (Object)proposal.getTask());
        doc = viewer.getDocument();
        proposal.apply(doc);
        RepositoryCompletionProcessorTest.assertEquals((String)"task 2", (String)doc.get());
        RepositoryCompletionProcessorTest.assertEquals((Object)new Point(6, 0), (Object)proposal.getSelection(doc));
        viewer = new MockTextViewer("bar*my");
        proposals = processor.computeCompletionProposals((ITextViewer)viewer, 6);
        RepositoryCompletionProcessorTest.assertEquals((int)1, (int)proposals.length);
        proposal = (RepositoryCompletionProcessor.TaskCompletionProposal)proposals[0];
        RepositoryCompletionProcessorTest.assertEquals((Object)task2, (Object)proposal.getTask());
        doc = viewer.getDocument();
        proposal.apply(doc);
        RepositoryCompletionProcessorTest.assertEquals((String)"task 2", (String)doc.get());
        RepositoryCompletionProcessorTest.assertEquals((Object)new Point(6, 0), (Object)proposal.getSelection(doc));
        proposals = processor.computeCompletionProposals((ITextViewer)new MockTextViewer("my*"), 3);
        RepositoryCompletionProcessorTest.assertEquals((int)2, (int)proposals.length);
        proposals = processor.computeCompletionProposals((ITextViewer)new MockTextViewer("my*none"), 7);
        RepositoryCompletionProcessorTest.assertEquals((int)0, (int)proposals.length);
        proposals = processor.computeCompletionProposals((ITextViewer)new MockTextViewer("foo*bar"), 7);
        RepositoryCompletionProcessorTest.assertEquals((int)0, (int)proposals.length);
    }

    private TaskTask addTask(String taskId, String summary) {
        TaskTask task = TaskTestUtil.createMockTask(taskId);
        task.setTaskKey(taskId);
        task.setSummary(summary);
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        return task;
    }
}

