/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.PriorityQueue;

abstract class DisjunctionScorer
extends Scorer {
    private final int numClauses;
    private final boolean needsScores;
    private final DisjunctionDISIApproximation approximation;
    private final TwoPhase twoPhase;

    protected DisjunctionScorer(List<Scorer> subScorers, ScoreMode scoreMode, long leadCost) throws IOException {
        if (subScorers.size() <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.numClauses = subScorers.size();
        this.needsScores = scoreMode != ScoreMode.COMPLETE_NO_SCORES;
        boolean hasApproximation = false;
        float sumMatchCost = 0.0f;
        long sumApproxCost = 0L;
        ArrayList<DisiWrapper> wrappers = new ArrayList<DisiWrapper>();
        for (Scorer scorer : subScorers) {
            DisiWrapper w = new DisiWrapper(scorer, false);
            long costWeight = w.cost <= 1L ? 1L : w.cost;
            sumApproxCost += costWeight;
            if (w.twoPhaseView != null) {
                hasApproximation = true;
                sumMatchCost += w.matchCost * (float)costWeight;
            }
            wrappers.add(w);
        }
        this.approximation = new DisjunctionDISIApproximation(wrappers, leadCost);
        if (!hasApproximation) {
            this.twoPhase = null;
        } else {
            float matchCost = sumMatchCost / (float)sumApproxCost;
            this.twoPhase = new TwoPhase(this.approximation, matchCost);
        }
    }

    @Override
    public DocIdSetIterator iterator() {
        if (this.twoPhase != null) {
            return TwoPhaseIterator.asDocIdSetIterator(this.twoPhase);
        }
        return this.approximation;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhase;
    }

    @Override
    public final int docID() {
        return this.approximation.docID();
    }

    DisiWrapper getSubMatches() throws IOException {
        if (this.twoPhase == null) {
            return this.approximation.topList();
        }
        return this.twoPhase.getSubMatches();
    }

    @Override
    public final float score() throws IOException {
        return this.score(this.getSubMatches());
    }

    protected abstract float score(DisiWrapper var1) throws IOException;

    @Override
    public final Collection<Scorable.ChildScorable> getChildren() throws IOException {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
        DisiWrapper scorer = this.getSubMatches();
        while (scorer != null) {
            children.add(new Scorable.ChildScorable(scorer.scorer, "SHOULD"));
            scorer = scorer.next;
        }
        return children;
    }

    private class TwoPhase
    extends TwoPhaseIterator {
        private final float matchCost;
        DisiWrapper verifiedMatches;
        final PriorityQueue<DisiWrapper> unverifiedMatches;

        private TwoPhase(DocIdSetIterator approximation, float matchCost) {
            super(approximation);
            this.matchCost = matchCost;
            this.unverifiedMatches = new PriorityQueue<DisiWrapper>(this, DisjunctionScorer.this.numClauses){

                @Override
                protected boolean lessThan(DisiWrapper a, DisiWrapper b) {
                    return a.matchCost < b.matchCost;
                }
            };
        }

        DisiWrapper getSubMatches() throws IOException {
            for (DisiWrapper w : this.unverifiedMatches) {
                if (!w.twoPhaseView.matches()) continue;
                w.next = this.verifiedMatches;
                this.verifiedMatches = w;
            }
            this.unverifiedMatches.clear();
            return this.verifiedMatches;
        }

        @Override
        public boolean matches() throws IOException {
            this.verifiedMatches = null;
            this.unverifiedMatches.clear();
            DisiWrapper w = DisjunctionScorer.this.approximation.topList();
            while (w != null) {
                DisiWrapper next = w.next;
                if (w.twoPhaseView == null) {
                    w.next = this.verifiedMatches;
                    this.verifiedMatches = w;
                    if (!DisjunctionScorer.this.needsScores) {
                        return true;
                    }
                } else {
                    this.unverifiedMatches.add(w);
                }
                w = next;
            }
            if (this.verifiedMatches != null) {
                return true;
            }
            while (this.unverifiedMatches.size() > 0) {
                w = this.unverifiedMatches.pop();
                if (!w.twoPhaseView.matches()) continue;
                w.next = null;
                this.verifiedMatches = w;
                return true;
            }
            return false;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }
    }
}

