/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util.junit4;

import java.text.MessageFormat;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.mylyn.commons.sdk.util.DumpThreadTask;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@RunListener.ThreadSafe
public class JUnitExecutionListener
extends RunListener {
    private static JUnitExecutionListener INSTANCE;
    private final CopyOnWriteArrayList<String> ingored = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<Description, DumpThreadTask> taskByTest = new ConcurrentHashMap();
    public static final long DELAY = 600000L;
    private final Timer timer = new Timer(true);

    public static JUnitExecutionListener getDefault() {
        return INSTANCE;
    }

    public static JUnitExecutionListener createDefault() {
        if (INSTANCE == null) {
            INSTANCE = new JUnitExecutionListener();
            return INSTANCE;
        }
        return null;
    }

    public void testRunFinished(Result result) throws Exception {
        this.dumpResults(result);
    }

    public void testStarted(Description description) throws Exception {
        System.err.println("Running " + description.toString());
        DumpThreadTask task = new DumpThreadTask(description.toString());
        this.taskByTest.put(description, task);
        this.timer.schedule((TimerTask)task, 600000L);
    }

    public void testFinished(Description description) throws Exception {
        DumpThreadTask task = this.taskByTest.remove(description);
        if (task != null) {
            task.cancel();
        }
        Thread.interrupted();
    }

    public void testFailure(Failure failure) throws Exception {
        if (failure.getException() instanceof AssertionError) {
            System.err.println("[FAILURE]");
        } else {
            System.err.println("[ERROR]");
        }
    }

    public void testIgnored(Description description) throws Exception {
        System.err.println("Ignored " + description.getMethodName());
        this.ingored.add(description.getMethodName());
    }

    private void dumpErrorList(List<Failure> failures) {
        System.err.println("Error: ");
        for (Failure failure : failures) {
            if (failure.getException() instanceof AssertionError) continue;
            System.err.print("  ");
            System.err.println(failure.toString());
        }
    }

    private void dumpFailureList(List<Failure> failures) {
        System.err.println("Failures: ");
        for (Failure failure : failures) {
            if (!(failure.getException() instanceof AssertionError)) continue;
            System.err.print("  ");
            System.err.println(failure.toString());
        }
    }

    private void dumpIgnored() {
        System.err.println("Ignored: ");
        for (String element : this.ingored) {
            System.err.print("  ");
            System.err.println(element);
        }
    }

    private void dumpResults(Result result) {
        if (result.getFailureCount() > 0) {
            System.err.println();
            this.dumpFailureList(result.getFailures());
            this.dumpErrorList(result.getFailures());
        }
        if (result.getIgnoreCount() > 0) {
            System.err.println();
            this.dumpIgnored();
        }
        System.err.println();
        System.err.println(MessageFormat.format("{0} out of {1} tests failed ({2} tests skipped)", result.getFailureCount(), result.getRunCount() + result.getIgnoreCount(), result.getIgnoreCount()));
    }
}

