/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.server;

import com.google.gwt.requestfactory.server.OperationRegistry;
import com.google.gwt.requestfactory.server.RequestDefinition;
import com.google.gwt.requestfactory.server.RequestSecurityProvider;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.InstanceRequest;
import com.google.gwt.requestfactory.shared.ProxyFor;
import com.google.gwt.requestfactory.shared.ProxyForName;
import com.google.gwt.requestfactory.shared.Request;
import com.google.gwt.requestfactory.shared.Service;
import com.google.gwt.requestfactory.shared.ServiceName;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectionBasedOperationRegistry
implements OperationRegistry {
    public static final String SCOPE_SEPARATOR = "::";
    private RequestSecurityProvider securityProvider;

    public ReflectionBasedOperationRegistry(RequestSecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public RequestDefinition getOperation(String operationName) {
        String decodedOperationName = this.securityProvider.mapOperation(operationName);
        String[] parts = decodedOperationName.split(SCOPE_SEPARATOR);
        String reqClassName = parts[0];
        String domainMethodName = parts[1];
        try {
            Class<?> domainClass;
            Class<?> requestClass = Class.forName(reqClassName, false, this.getClass().getClassLoader());
            this.securityProvider.checkClass(requestClass);
            Service domainClassAnnotation = requestClass.getAnnotation(Service.class);
            ServiceName domainClassNameAnnotation = requestClass.getAnnotation(ServiceName.class);
            if (domainClassAnnotation != null) {
                domainClass = domainClassAnnotation.value();
            } else if (domainClassNameAnnotation != null) {
                domainClass = Class.forName(domainClassNameAnnotation.value(), false, Thread.currentThread().getContextClassLoader());
            } else {
                return null;
            }
            Method requestMethod = this.findMethod(requestClass, domainMethodName);
            Method domainMethod = this.findMethod(domainClass, domainMethodName);
            if (requestMethod != null && domainMethod != null) {
                boolean isInstance = InstanceRequest.class.isAssignableFrom(requestMethod.getReturnType());
                if (isInstance == Modifier.isStatic(domainMethod.getModifiers())) {
                    throw new IllegalArgumentException("domain method " + domainMethod + " and interface method " + requestMethod + " don't match wrt instance/static");
                }
                return new ReflectiveRequestDefinition(requestClass, requestMethod, domainClass, domainMethod, isInstance);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new SecurityException("Access to non-existent class " + reqClassName);
        }
    }

    @Override
    public RequestSecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    private Method findMethod(Class<?> clazz, String methodName) {
        for (Method method : clazz.getDeclaredMethods()) {
            if ((method.getModifiers() & 1) == 0 || !method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReflectiveRequestDefinition
    implements RequestDefinition {
        private Class<?> requestClass;
        private Method requestMethod;
        private Class<?> domainClass;
        private Method domainMethod;
        private boolean isInstance;

        public ReflectiveRequestDefinition(Class<?> requestClass, Method requestMethod, Class<?> domainClass, Method domainMethod, boolean isInstance) {
            this.requestClass = requestClass;
            this.requestMethod = requestMethod;
            this.domainClass = domainClass;
            this.domainMethod = domainMethod;
            this.isInstance = isInstance;
        }

        @Override
        public String getDomainClassName() {
            return this.domainClass.getCanonicalName();
        }

        @Override
        public Method getDomainMethod() {
            return this.domainMethod;
        }

        public String getDomainMethodName() {
            return this.getDomainMethod().getName();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.domainMethod.getParameterTypes();
        }

        @Override
        public Type[] getRequestParameterTypes() {
            Type[] toReturn = this.requestMethod.getGenericParameterTypes();
            if (this.isInstance()) {
                Type[] newReturn = new Type[toReturn.length + 1];
                newReturn[0] = this.domainMethod.getDeclaringClass();
                System.arraycopy(toReturn, 0, newReturn, 1, toReturn.length);
                toReturn = newReturn;
            }
            return toReturn;
        }

        @Override
        public Class<?> getReturnType() {
            Class<?> domainReturnType = this.getReturnTypeFromParameter(this.domainMethod, this.domainMethod.getGenericReturnType());
            Class<?> requestReturnType = this.getReturnTypeFromParameter(this.requestMethod, this.requestMethod.getGenericReturnType());
            if (EntityProxy.class.isAssignableFrom(requestReturnType)) {
                ProxyFor annotation = requestReturnType.getAnnotation(ProxyFor.class);
                ProxyForName nameAnnotation = requestReturnType.getAnnotation(ProxyForName.class);
                Class<?> dtoClass = null;
                if (annotation != null) {
                    dtoClass = annotation.value();
                } else if (nameAnnotation != null) {
                    try {
                        dtoClass = Class.forName(nameAnnotation.value(), false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Unknown type specified in ProxyForName annotation", e);
                    }
                } else {
                    throw new IllegalArgumentException("Missing ProxyFor annotation on proxy type " + requestReturnType);
                }
                if (!dtoClass.equals(domainReturnType)) {
                    throw new IllegalArgumentException("Type mismatch between " + this.domainMethod + " return type, and " + requestReturnType + "'s ProxyFor annotation " + dtoClass);
                }
                return requestReturnType;
            }
            return requestReturnType;
        }

        @Override
        public boolean isInstance() {
            return this.isInstance;
        }

        @Override
        public String name() {
            return this.requestClass.getCanonicalName() + ReflectionBasedOperationRegistry.SCOPE_SEPARATOR + this.getDomainMethodName();
        }

        private Class<?> getReturnTypeFromParameter(Method method, Type type) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Class rawType = (Class)pType.getRawType();
                if (List.class.isAssignableFrom(rawType) || Request.class.isAssignableFrom(rawType) || InstanceRequest.class.isAssignableFrom(rawType)) {
                    Class<?> rType = this.getTypeArgument(pType);
                    if (rType != null) {
                        if (List.class.isAssignableFrom(rType)) {
                            return this.getReturnTypeFromParameter(method, rType);
                        }
                        return rType;
                    }
                    throw new IllegalArgumentException("Bad or missing type arguments for List return type on method " + method);
                }
                if (Set.class.isAssignableFrom(rawType) || Request.class.isAssignableFrom(rawType) || InstanceRequest.class.isAssignableFrom(rawType)) {
                    Class<?> rType = this.getTypeArgument(pType);
                    if (rType != null) {
                        if (Set.class.isAssignableFrom(rType)) {
                            return this.getReturnTypeFromParameter(method, rType);
                        }
                        return rType;
                    }
                    throw new IllegalArgumentException("Bad or missing type arguments for Set return type on method " + method);
                }
            } else {
                return (Class)type;
            }
            return null;
        }

        private Class<?> getTypeArgument(ParameterizedType type) {
            Type toExamine;
            Type[] params = type.getActualTypeArguments();
            if (params.length == 1) {
                toExamine = params[0];
            } else if (InstanceRequest.class.equals((Object)type.getRawType())) {
                toExamine = params[1];
            } else {
                return null;
            }
            if (toExamine instanceof ParameterizedType) {
                return this.getTypeArgument((ParameterizedType)toExamine);
            }
            return (Class)toExamine;
        }
    }
}

