/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.core;

import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.gitlab.core.GitlabException;
import org.eclipse.mylyn.internal.gitlab.core.GitlabOperation;

public abstract class GitlabPutOperation<T>
extends GitlabOperation<T> {
    private final String body;

    public GitlabPutOperation(CommonHttpClient client, String urlSuffix, String body) {
        super(client, urlSuffix);
        this.body = body;
    }

    @Override
    protected HttpRequestBase createHttpRequestBase(String url) {
        HttpPut request = new HttpPut(url);
        return request;
    }

    @Override
    protected void addHttpRequestEntities(HttpRequestBase request) throws GitlabException {
        super.addHttpRequestEntities(request);
        request.setHeader("Content-Type", "application/json");
        try {
            ((HttpPut)request).setEntity((HttpEntity)new StringEntity(this.body));
        }
        catch (UnsupportedEncodingException e) {
            throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "UnsupportedEncodingException", (Throwable)e));
        }
    }
}

