/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.bugzilla.ui.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;

public final class TaskAttachmentHyperlink
implements IHyperlink {
    private final IRegion region;
    private final TaskRepository repository;
    private final String attachmentId;

    public TaskAttachmentHyperlink(IRegion region, TaskRepository repository, String attachmentId) {
        Assert.isNotNull((Object)repository);
        this.region = region;
        this.repository = repository;
        this.attachmentId = attachmentId;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return MessageFormat.format(Messages.TaskAttachmentHyperlink_Open_Attachment_X_in_Y, this.attachmentId, this.repository.getRepositoryLabel());
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        String url = this.repository.getUrl() + "/attachment.cgi?id=" + this.attachmentId;
        TasksUiUtil.openUrl((String)url);
    }

    public int hashCode() {
        return Objects.hash(this.attachmentId, this.region, this.repository);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskAttachmentHyperlink other = (TaskAttachmentHyperlink)obj;
        if (!Objects.equals(this.attachmentId, other.attachmentId)) {
            return false;
        }
        if (!Objects.equals(this.region, other.region)) {
            return false;
        }
        return Objects.equals(this.repository, other.repository);
    }

    public String toString() {
        return "TaskAttachmentHyperlink [attachmentId=" + this.attachmentId + ", region=" + String.valueOf(this.region) + ", repository=" + String.valueOf(this.repository) + "]";
    }
}

