/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class ReviewTableData {
    private Map<String, GerritTask> fReviewList;
    private TaskRepository fTaskRepo = null;
    private String fQuery = null;

    public void createReviewItem(GerritTask[] aList, String aQuery, TaskRepository aTaskRepo) {
        this.fReviewList = new ConcurrentHashMap<String, GerritTask>();
        GerritTask[] gerritTaskArray = aList;
        int n = aList.length;
        int n2 = 0;
        while (n2 < n) {
            GerritTask review = gerritTaskArray[n2];
            this.fReviewList.put(review.getAttribute("task.common.key"), review);
            ++n2;
        }
        this.fTaskRepo = aTaskRepo;
        this.fQuery = aQuery;
    }

    public void createReviewItem(String query, TaskRepository repository) {
        this.fReviewList = new HashMap<String, GerritTask>();
        this.fTaskRepo = repository;
        this.fQuery = query;
    }

    public void updateReviewItem(GerritTask task) {
        this.fReviewList.put(task.getTaskId(), task);
    }

    public void deleteReviewItem(String taskId) {
        this.fReviewList.remove(taskId);
    }

    public GerritTask[] getReviews() {
        if (this.fReviewList == null) {
            this.fReviewList = new HashMap<String, GerritTask>();
        }
        return this.fReviewList.values().toArray(new GerritTask[0]);
    }

    public GerritTask getReview(String id) {
        if (id != null && this.fReviewList.containsKey(id)) {
            return this.fReviewList.get(id);
        }
        return null;
    }

    public TaskRepository getCurrentTaskRepo() {
        return this.fTaskRepo;
    }

    public String getQueryInfo() {
        return this.fQuery;
    }

    public void init(GerritTask[] reviews) {
        GerritTask[] gerritTaskArray = reviews;
        int n = reviews.length;
        int n2 = 0;
        while (n2 < n) {
            GerritTask review = gerritTaskArray[n2];
            this.fReviewList.put(review.getTaskId(), review);
            ++n2;
        }
    }
}

