/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.ui.TaskJobFactory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

public class TaskJobFactoryTest
extends TestCase {
    private TaskJobFactory jobFactory;
    private boolean oldFetchSubtasks;

    protected void setUp() throws Exception {
        this.jobFactory = TasksUiPlugin.getTaskJobFactory();
        this.oldFetchSubtasks = this.jobFactory.getFetchSubtasks();
    }

    protected void tearDown() throws Exception {
        this.jobFactory.setFetchSubtasks(this.oldFetchSubtasks);
    }

    public void testFetchSubtasksDefaultValue() throws Exception {
        TaskJobFactoryTest.assertTrue((boolean)TasksUiPlugin.getTaskJobFactory().getFetchSubtasks());
    }

    private void assertFetchSubtasks(JobCreator jobCreator) {
        this.jobFactory.setFetchSubtasks(true);
        TaskJobFactoryTest.assertTrue((boolean)jobCreator.createJob().getFetchSubtasks());
        this.jobFactory.setFetchSubtasks(false);
        TaskJobFactoryTest.assertFalse((boolean)jobCreator.createJob().getFetchSubtasks());
    }

    public void testCreateSynchronizeTasksJob() {
        this.assertFetchSubtasks(new JobCreator(){

            @Override
            public SynchronizationJob createJob() {
                return TaskJobFactoryTest.this.jobFactory.createSynchronizeTasksJob(null, Collections.emptySet());
            }
        });
        this.assertFetchSubtasks(new JobCreator(){

            @Override
            public SynchronizationJob createJob() {
                return TaskJobFactoryTest.this.jobFactory.createSynchronizeTasksJob(null, null, Collections.emptySet());
            }
        });
    }

    public void testCreateSynchronizeQueriesJob() {
        this.assertFetchSubtasks(new JobCreator(){

            @Override
            public SynchronizationJob createJob() {
                return TaskJobFactoryTest.this.jobFactory.createSynchronizeQueriesJob(null, new TaskRepository("mock", "http://mock"), Collections.emptySet());
            }
        });
    }

    public void testCreateSynchronizeRepositoriesJob() {
        this.assertFetchSubtasks(new JobCreator(){

            @Override
            public SynchronizationJob createJob() {
                return TaskJobFactoryTest.this.jobFactory.createSynchronizeRepositoriesJob(null);
            }
        });
    }

    private static abstract class JobCreator {
        private JobCreator() {
        }

        public abstract SynchronizationJob createJob();
    }
}

