/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDataSnapshotOperation;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataExportWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataExportWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class TaskDataExportTest
extends TestCase {
    private File destinationDir;
    private File mylynFolder;
    private final List<File> tempFiles = new ArrayList<File>();
    private TaskDataExportWizard wizard;
    private TaskDataExportWizardPage wizardPage;

    private File createDirectory(File parent, String folderName) {
        File file = new File(parent, folderName);
        if (!file.exists()) {
            TaskDataExportTest.assertTrue((boolean)file.mkdir());
            this.tempFiles.add(file);
        }
        return file;
    }

    private File createFile(File directory, String fileName) throws IOException {
        File file = new File(directory, fileName);
        if (!file.exists()) {
            TaskDataExportTest.assertTrue((boolean)file.createNewFile());
            this.tempFiles.add(file);
        }
        return file;
    }

    private List<String> getEntries(File file) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                entries.add(entry.getName());
                entry = zipInputStream.getNextEntry();
            }
        }
        Collections.sort(entries);
        return entries;
    }

    protected void setUp() throws Exception {
        this.wizard = new TaskDataExportWizard();
        this.wizard.addPages();
        this.wizard.createPageControls((Composite)new Shell());
        this.wizardPage = (TaskDataExportWizardPage)this.wizard.getPage("org.eclipse.mylyn.tasklist.exportPage");
        TaskDataExportTest.assertNotNull((Object)this.wizardPage);
        this.mylynFolder = new File(TasksUiPlugin.getDefault().getDataDirectory());
        File contextDirectory = new File(this.mylynFolder, "contexts");
        CommonTestUtil.deleteFolder((File)contextDirectory);
        contextDirectory.mkdir();
        File tasksDirectory = new File(this.mylynFolder, "tasks");
        CommonTestUtil.deleteFolderRecursively((File)tasksDirectory);
        tasksDirectory.mkdir();
        this.destinationDir = new File(this.mylynFolder.getParent(), "TestDir");
        CommonTestUtil.deleteFolder((File)this.destinationDir);
        this.createDirectory(this.destinationDir.getParentFile(), this.destinationDir.getName());
        this.createFile(this.mylynFolder, "monitor-log.xml");
        this.createFile(this.mylynFolder, "my-tasklist.xml.zip");
        this.createFile(this.mylynFolder, "tasks.xml.zip");
        this.createFile(this.mylynFolder, "tasklist.xml.zip");
        this.createFile(this.mylynFolder, ".hidden");
        this.createDirectory(this.mylynFolder, "my-attachments");
        this.createDirectory(this.mylynFolder, "attachments");
        this.createDirectory(this.mylynFolder, "backup");
        File tasksandstuff = this.createDirectory(this.mylynFolder, "tasksandstuff");
        this.createFile(tasksandstuff, "file1.xml.zip");
        File taskSubDir = this.createDirectory(tasksandstuff, "sub");
        this.createFile(taskSubDir, "file2.xml.zip");
    }

    protected void tearDown() throws Exception {
        this.wizard.dispose();
        this.wizardPage.dispose();
        Collections.reverse(this.tempFiles);
        for (File file : this.tempFiles) {
            file.delete();
        }
    }

    public void testExportAllToZip() throws Exception {
        this.wizardPage.setDestinationDirectory(this.destinationDir.getPath());
        this.wizard.performFinish();
        File[] files = this.destinationDir.listFiles();
        TaskDataExportTest.assertEquals((int)1, (int)files.length);
        List<String> entries = this.getEntries(files[0]);
        TaskDataExportTest.assertEquals(Arrays.asList("my-tasklist.xml.zip", "repositories.xml.zip", "tasks.xml.zip", "tasksandstuff/file1.xml.zip", "tasksandstuff/sub/file2.xml.zip"), entries);
    }

    public void testSnapshotWithContext() throws Exception {
        File activityFile = new File(this.mylynFolder, "contexts/activity.xml.zip");
        if (!activityFile.exists()) {
            TaskDataExportTest.assertTrue((boolean)activityFile.createNewFile());
        }
        TaskDataSnapshotOperation backupJob = new TaskDataSnapshotOperation(this.destinationDir.getPath(), "testBackup.zip");
        backupJob.run((IProgressMonitor)new NullProgressMonitor());
        File[] files = this.destinationDir.listFiles();
        TaskDataExportTest.assertEquals((int)1, (int)files.length);
        List<String> entries = this.getEntries(files[0]);
        TaskDataExportTest.assertEquals(Arrays.asList("contexts/activity.xml.zip", "repositories.xml.zip", "tasks.xml.zip"), entries);
    }

    public void testSnapshotWithoutContext() throws Exception {
        File activityFile = new File(this.mylynFolder, "contexts/activity.xml.zip");
        if (activityFile.exists()) {
            TaskDataExportTest.assertTrue((boolean)activityFile.delete());
        }
        TaskDataSnapshotOperation backupJob = new TaskDataSnapshotOperation(this.destinationDir.getPath(), "testBackup.zip");
        backupJob.run((IProgressMonitor)new NullProgressMonitor());
        File[] files = this.destinationDir.listFiles();
        TaskDataExportTest.assertEquals((int)1, (int)files.length);
        List<String> entries = this.getEntries(files[0]);
        TaskDataExportTest.assertEquals(Arrays.asList("repositories.xml.zip", "tasks.xml.zip"), entries);
    }
}

