/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.externalization.LazyTransferList;
import org.eclipse.mylyn.tasks.core.ITask;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LazyTransferListTest {
    private ITransferList taskList;
    private LazyTransferList lazyList;

    @Before
    public void setUp() throws Exception {
        this.taskList = (ITransferList)Mockito.mock(TaskList.class);
        this.lazyList = new LazyTransferList(this.taskList);
    }

    @Test
    public void addUnmatchedTask() {
        AbstractTask task = (AbstractTask)Mockito.spy((Object)new TaskTask("kind", "repoUrl", "id"));
        this.lazyList.addTask((ITask)task);
        ((ITransferList)Mockito.verify((Object)this.taskList, (VerificationMode)Mockito.never())).addTask((ITask)task);
        ((ITransferList)Mockito.verify((Object)this.taskList, (VerificationMode)Mockito.never())).addTask((ITask)Matchers.eq((Object)task), (AbstractTaskContainer)Matchers.any());
        this.lazyList.commit();
        ((ITransferList)Mockito.verify((Object)this.taskList)).addTask((ITask)task);
        this.lazyList.commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskList});
    }

    @Test
    public void addSubTask() {
        AbstractTask task = (AbstractTask)Mockito.spy((Object)new TaskTask("kind", "repoUrl", "parent"));
        AbstractTask subTask = (AbstractTask)Mockito.spy((Object)new TaskTask("kind", "repoUrl", "child"));
        this.lazyList.addTask((ITask)subTask);
        this.lazyList.addTask((ITask)task);
        this.lazyList.addTask((ITask)subTask, (AbstractTaskContainer)task);
        ((ITransferList)Mockito.verify((Object)this.taskList)).addTask((ITask)task);
        ((ITransferList)Mockito.verify((Object)this.taskList)).addTask((ITask)subTask, (AbstractTaskContainer)task);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskList});
        this.lazyList.commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskList});
    }
}

