/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.net.URL;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.util.ConcurrentTaskManager;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvisioningJobListener
extends JobChangeAdapter {
    private final Set<CatalogItem> installItems;

    public ProvisioningJobListener(Set<CatalogItem> installItems) {
        this.installItems = installItems;
    }

    public void done(IJobChangeEvent event) {
        if (event.getResult().isOK()) {
            Job job = new Job(Messages.ProvisioningJobListener_notificationTaskName){
                {
                    this.setPriority(30);
                    this.setSystem(true);
                    this.setUser(true);
                }

                protected IStatus run(final IProgressMonitor monitor) {
                    ConcurrentTaskManager taskManager = new ConcurrentTaskManager(ProvisioningJobListener.this.installItems.size(), Messages.ProvisioningJobListener_notificationTaskName);
                    for (CatalogItem item : ProvisioningJobListener.this.installItems) {
                        if (!(item instanceof MarketplaceNodeCatalogItem)) continue;
                        final MarketplaceNodeCatalogItem nodeItem = (MarketplaceNodeCatalogItem)item;
                        taskManager.submit(new Runnable(){

                            public void run() {
                                INode node = nodeItem.getData();
                                URL marketplaceUrl = nodeItem.getMarketplaceUrl();
                                IMarketplaceService marketplaceService = ServiceHelper.getMarketplaceServiceLocator().getMarketplaceService(marketplaceUrl.toString());
                                marketplaceService.reportInstallSuccess(node, (IProgressMonitor)new NullProgressMonitor(){

                                    public boolean isCanceled() {
                                        return monitor.isCanceled();
                                    }
                                });
                            }
                        });
                    }
                    try {
                        taskManager.waitUntilFinished(monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

