/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Locale;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.win.WindowsCredentialsProvider;
import org.apache.http.impl.auth.win.WindowsNTLMSchemeFactory;
import org.apache.http.impl.auth.win.WindowsNegotiateSchemeFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;

public class WinHttpClients {
    private WinHttpClients() {
    }

    public static boolean isWinAuthAvailable() {
        String os = System.getProperty("os.name");
        String string = os = os != null ? os.toLowerCase(Locale.ROOT) : null;
        if (os != null && os.contains("windows")) {
            try {
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }
        return false;
    }

    private static HttpClientBuilder createBuilder() {
        if (WinHttpClients.isWinAuthAvailable()) {
            Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory()).register("NTLM", (Object)new WindowsNTLMSchemeFactory(null)).register("Negotiate", (Object)new WindowsNegotiateSchemeFactory(null)).build();
            WindowsCredentialsProvider credsProvider = new WindowsCredentialsProvider((CredentialsProvider)new SystemDefaultCredentialsProvider());
            return HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        }
        return HttpClientBuilder.create();
    }

    public static HttpClientBuilder custom() {
        return WinHttpClients.createBuilder();
    }

    public static CloseableHttpClient createDefault() {
        return WinHttpClients.createBuilder().build();
    }

    public static CloseableHttpClient createSystem() {
        return WinHttpClients.createBuilder().useSystemProperties().build();
    }
}

