/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;

public class ChainedCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider first;
    private final CredentialsProvider second;

    public ChainedCredentialsProvider(CredentialsProvider first, CredentialsProvider second) {
        this.first = first;
        this.second = second;
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.first.setCredentials(authscope, credentials);
    }

    public Credentials getCredentials(AuthScope authscope) {
        Credentials credentials = this.first.getCredentials(authscope);
        if (credentials != null) {
            return credentials;
        }
        return this.second.getCredentials(authscope);
    }

    public void clear() {
        this.first.clear();
        this.second.clear();
    }

    CredentialsProvider getFirst() {
        return this.first;
    }

    CredentialsProvider getSecond() {
        return this.second;
    }
}

