/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.MarketplaceUnmarshaller;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.util.ServiceUtil;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.mpc.core.service.IMarketplaceUnmarshaller;
import org.eclipse.epp.mpc.core.service.ITransport;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.eclipse.epp.mpc.core.service.UnmarshalException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteMarketplaceService<T> {
    protected URL baseUrl;
    public static final String API_URI_SUFFIX = "api/p";
    protected static final String UTF_8 = "UTF-8";
    private static final int RETRY_COUNT = 3;
    protected final ITransport transport = TransportFactory.createTransport();
    protected final IMarketplaceUnmarshaller unmarshaller;
    private Map<String, String> requestMetaParameters;

    public RemoteMarketplaceService() {
        IMarketplaceUnmarshaller unmarshaller = ServiceHelper.getMarketplaceUnmarshaller();
        if (unmarshaller == null) {
            unmarshaller = new MarketplaceUnmarshaller();
        }
        this.unmarshaller = unmarshaller;
    }

    protected IStatus createErrorStatus(String message, Throwable t) {
        return this.createStatus(4, message, t);
    }

    protected IStatus createStatus(int severity, String message, Throwable t) {
        return new Status(severity, "org.eclipse.epp.mpc.core", 0, message, t);
    }

    private void checkConfiguration() {
        if (this.baseUrl == null) {
            throw new IllegalStateException(Messages.DefaultMarketplaceService_mustConfigureBaseUrl);
        }
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected T processRequest(String relativeUrl, IProgressMonitor monitor) throws CoreException {
        return this.processRequest(relativeUrl, true, monitor);
    }

    protected T processRequest(String relativeUrl, boolean withMetaParams, IProgressMonitor monitor) throws CoreException {
        URI baseUri;
        try {
            baseUri = this.baseUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return this.processRequest(baseUri.toString(), relativeUrl, withMetaParams, monitor);
    }

    protected T processRequest(String baseUri, String relativePath, IProgressMonitor monitor) throws CoreException {
        return this.processRequest(baseUri, relativePath, true, monitor);
    }

    /*
     * Loose catch block
     */
    protected T processRequest(String baseUri, String relativePath, boolean withMetaParams, IProgressMonitor monitor) throws CoreException {
        URI location;
        this.checkConfiguration();
        if (baseUri == null || relativePath == null) {
            throw new IllegalArgumentException();
        }
        String uri = URLUtil.appendPath(baseUri, relativePath);
        if (withMetaParams) {
            uri = this.addMetaParameters(uri);
        }
        try {
            location = new URI(uri);
        }
        catch (URISyntaxException e) {
            String message = NLS.bind((String)Messages.DefaultMarketplaceService_invalidLocation, (Object)uri);
            throw new CoreException(this.createErrorStatus(message, e));
        }
        int retry = 0;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.DefaultMarketplaceService_retrievingDataFrom, (Object)baseUri), (int)100);
        while (true) {
            Object object;
            InputStream in;
            block20: {
                progress.setWorkRemaining(100);
                in = this.transport.stream(location, (IProgressMonitor)progress.newChild(70));
                progress.setWorkRemaining(100);
                progress.worked(30);
                object = this.unmarshaller.unmarshal(in, Object.class, (IProgressMonitor)progress.newChild(70));
                if (in == null) break block20;
                in.close();
            }
            return (T)object;
            {
                catch (UnmarshalException e) {
                    try {
                        try {
                            MarketplaceClientCore.error(NLS.bind((String)Messages.DefaultMarketplaceService_parseError, (Object)location.toString()), (Throwable)((Object)e));
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e22222) {
                        CoreException e22222;
                        if (e22222.getCause() instanceof OperationCanceledException) {
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                        String causeMessage = e22222.getMessage();
                        String message = NLS.bind((String)Messages.DefaultMarketplaceService_cannotCompleteRequest_reason, (Object)location.toString(), (Object)causeMessage);
                        if (MarketplaceClientCore.isFailedDownloadException(e22222)) {
                            if (++retry < 3) {
                                MarketplaceClientCore.getLog().log(this.createStatus(1, message, e22222));
                                continue;
                            }
                            IStatus connectionProblemStatus = MarketplaceClientCore.createConnectionProblemStatus(e22222);
                            causeMessage = connectionProblemStatus.getMessage();
                            e22222 = new CoreException(connectionProblemStatus);
                            message = NLS.bind((String)Messages.DefaultMarketplaceService_cannotCompleteRequest_reason, (Object)location.toString(), (Object)causeMessage);
                        }
                        throw new CoreException(this.createErrorStatus(message, e22222));
                    }
                }
            }
            break;
        }
        finally {
            monitor.done();
        }
    }

    public String addMetaParameters(String uri) {
        if (this.requestMetaParameters != null) {
            try {
                boolean hasQueryString = uri.indexOf(63) != -1;
                for (Map.Entry<String, String> param : this.requestMetaParameters.entrySet()) {
                    if (param.getKey() == null) continue;
                    if (hasQueryString) {
                        uri = String.valueOf(uri) + '&';
                    } else {
                        hasQueryString = true;
                        uri = String.valueOf(uri) + '?';
                    }
                    uri = String.valueOf(uri) + URLEncoder.encode(param.getKey(), UTF_8);
                    uri = String.valueOf(uri) + '=';
                    if (param.getValue() == null) continue;
                    uri = String.valueOf(uri) + URLEncoder.encode(param.getValue(), UTF_8);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return uri;
    }

    public Map<String, String> getRequestMetaParameters() {
        return this.requestMetaParameters;
    }

    public void setRequestMetaParameters(Map<String, String> requestMetaParameters) {
        this.requestMetaParameters = requestMetaParameters;
    }

    protected static String urlEncode(String urlPart) {
        try {
            return URLEncoder.encode(urlPart, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void activate(Map<?, ?> properties) {
        URL url;
        if (properties != null && (url = ServiceUtil.getUrl(properties, "url", null)) != null) {
            this.setBaseUrl(url);
        }
    }
}

