/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.mpc.ui;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.epp.mpc.ui.IMarketplaceClientService;

public class MarketplaceClient {
    public static void addCatalogDescriptor(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        CatalogRegistry.getInstance().register(catalogDescriptor);
    }

    public static void removeCatalogDescriptor(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        CatalogRegistry.getInstance().unregister(catalogDescriptor);
    }

    public static void openMarketplaceWizard(List<CatalogDescriptor> catalogDescriptors) throws IllegalArgumentException, ExecutionException {
        if (catalogDescriptors != null) {
            if (catalogDescriptors.isEmpty()) {
                throw new IllegalArgumentException();
            }
            for (CatalogDescriptor descriptor : catalogDescriptors) {
                if (descriptor.getUrl() == null) {
                    throw new IllegalArgumentException();
                }
                if (descriptor.getLabel() != null) continue;
                throw new IllegalArgumentException();
            }
        }
        IMarketplaceClientService clientService = MarketplaceClient.getMarketplaceClientService();
        IMarketplaceClientConfiguration config = clientService.newConfiguration();
        if (catalogDescriptors != null) {
            config.setCatalogDescriptors(catalogDescriptors);
        }
        clientService.open(config);
    }

    public static IMarketplaceClientService getMarketplaceClientService() {
        return MarketplaceClientUiPlugin.getInstance().getClientService();
    }
}

