/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.util.Map;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

abstract class CacheCredentialsAuthenticationStrategy
implements AuthenticationStrategy {
    public static final String CREDENTIALS_CACHE_ATTRIBUTE = String.valueOf(CacheCredentialsAuthenticationStrategy.class.getName()) + ".credentialsCache";
    private final AuthenticationStrategy delegate;

    public CacheCredentialsAuthenticationStrategy(AuthenticationStrategy delegate) {
        this.delegate = delegate;
    }

    public boolean isAuthenticationRequested(HttpHost authhost, HttpResponse response, HttpContext context) {
        return this.delegate.isAuthenticationRequested(authhost, response, context);
    }

    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        return this.delegate.getChallenges(authhost, response, context);
    }

    public Queue<AuthOption> select(Map<String, Header> challenges, HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        return this.delegate.select(challenges, authhost, response, context);
    }

    public void authSucceeded(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        this.delegate.authSucceeded(authhost, authScheme, context);
        if (authScheme != null && authScheme.isComplete()) {
            this.cacheCredentials(authhost, authScheme, context);
        }
    }

    public void authFailed(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        this.delegate.authFailed(authhost, authScheme, context);
        this.uncacheCredentials(authhost, authScheme, context);
    }

    private void uncacheCredentials(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        CredentialsProvider credentialsCache = CacheCredentialsAuthenticationStrategy.getCredentialsCache(context);
        if (credentialsCache != null) {
            AuthScope scope = CacheCredentialsAuthenticationStrategy.createAuthScope(authhost, authScheme);
            credentialsCache.setCredentials(scope, null);
        }
    }

    private void cacheCredentials(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        CredentialsProvider credentialsCache;
        Credentials credentials = this.getCredentials(context);
        if (credentials != null && (credentialsCache = CacheCredentialsAuthenticationStrategy.getCredentialsCache(context)) != null) {
            AuthScope scope = CacheCredentialsAuthenticationStrategy.createAuthScope(authhost, authScheme);
            credentialsCache.setCredentials(scope, credentials);
        }
    }

    protected Credentials getCredentials(HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        AuthState authState = this.getAuthState(clientContext);
        if (authState != null) {
            return authState.getCredentials();
        }
        return null;
    }

    protected abstract AuthState getAuthState(HttpClientContext var1);

    private static CredentialsProvider getCredentialsCache(HttpContext context) {
        CredentialsProvider credentialsCache = null;
        Object value = context.getAttribute(CREDENTIALS_CACHE_ATTRIBUTE);
        if (value instanceof CredentialsProvider) {
            credentialsCache = (CredentialsProvider)value;
        }
        return credentialsCache;
    }

    private static AuthScope createAuthScope(HttpHost targetHost, AuthScheme scheme) {
        String schemeName = null;
        String realm = null;
        if (scheme != null) {
            schemeName = scheme.getSchemeName();
            realm = scheme.getRealm();
        }
        return new AuthScope(targetHost, realm, schemeName);
    }

    static class Proxy
    extends CacheCredentialsAuthenticationStrategy {
        public Proxy(AuthenticationStrategy delegate) {
            super(delegate);
        }

        @Override
        protected AuthState getAuthState(HttpClientContext clientContext) {
            return clientContext.getProxyAuthState();
        }
    }

    static class Target
    extends CacheCredentialsAuthenticationStrategy {
        public Target(AuthenticationStrategy delegate) {
            super(delegate);
        }

        @Override
        protected AuthState getAuthState(HttpClientContext clientContext) {
            return clientContext.getTargetAuthState();
        }
    }
}

