/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;

public class HttpUtil {
    public static HttpClient createHttpClient(String baseUri) {
        HttpClientBuilder hcBuilder = HttpClients.custom();
        hcBuilder.setUserAgent("org.eclipse.epp.mpc.core");
        if (baseUri != null) {
            HttpUtil.configureProxy(hcBuilder, baseUri);
        }
        return hcBuilder.build();
    }

    public static void configureProxy(HttpClientBuilder hcBuilder, String url) {
        IProxyData proxyData = ProxyHelper.getProxyData(url);
        if (proxyData != null && !"SOCKS".equals(proxyData.getType())) {
            HttpHost proxy = new HttpHost(proxyData.getHost(), proxyData.getPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            hcBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            if (proxyData.isRequiresAuthentication()) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(new AuthScope(proxyData.getHost(), proxyData.getPort()), (Credentials)new UsernamePasswordCredentials(proxyData.getUserId(), proxyData.getPassword()));
                hcBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
        }
    }
}

