/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.refactoring;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.refactoring.impl.AbstractProcessorBasedRenameParticipant;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreRefactoringParticipant
extends AbstractProcessorBasedRenameParticipant {
    @Deprecated
    public static final String ECORE_REFACTORING_PARTICIPANT_SHOW_WARNING_OPTION = "org.eclipse.xtext.xtext.ui.refactoring.EcoreRefactoringParticipant.show.warning.option";
    private static boolean isDisableWarning;
    @Inject
    private IResourceDescriptions resourceDescriptions;

    protected List<? extends IRenameElementContext> createRenameElementContexts(Object element) {
        if (element instanceof IRenameElementContext && ((IRenameElementContext)element).getTargetElementEClass() == XtextPackage.Literals.PARSER_RULE) {
            return super.createRenameElementContexts(element);
        }
        return null;
    }

    protected List<EObject> getRenamedElementsOrProxies(EObject originalTarget) {
        TypeRef returnType;
        if (originalTarget instanceof ParserRule && (returnType = ((ParserRule)originalTarget).getType()) != null && returnType.getClassifier() != null && !Strings.isEmpty((String)returnType.getClassifier().getName()) && Strings.equal((String)((ParserRule)originalTarget).getName(), (String)returnType.getClassifier().getName()) && returnType.getClassifier().eClass() != null && returnType.getClassifier().getEPackage() != null && !Strings.isEmpty((String)returnType.getClassifier().getEPackage().getNsURI())) {
            String packageNsURI = returnType.getClassifier().getEPackage().getNsURI();
            QualifiedName classifierQualifiedName = QualifiedName.create((String[])new String[]{packageNsURI, returnType.getClassifier().getName()});
            URI platformResourceURI = this.findPlatformResourceURI(classifierQualifiedName, EcorePackage.Literals.ECLASS);
            if (platformResourceURI == null) {
                if (returnType.getMetamodel() instanceof ReferencedMetamodel) {
                    this.getStatus().add(3, "Return type '{0}' is not indexed.", (EObject)returnType.getClassifier());
                }
            } else {
                EObject classifierProxy = EcoreFactory.eINSTANCE.create(returnType.getClassifier().eClass());
                ((InternalEObject)classifierProxy).eSetProxyURI(platformResourceURI);
                if (!isDisableWarning) {
                    this.getStatus().add(2, "Renaming EClass '{0}' in ecore file. Please rerun the Ecore generator.", (EObject)returnType.getClassifier());
                }
                return Collections.singletonList(classifierProxy);
            }
        }
        return null;
    }

    private URI findPlatformResourceURI(QualifiedName name, EClass type) {
        for (IResourceDescription resourceDescription : this.resourceDescriptions.getAllResourceDescriptions()) {
            if (!Strings.equal((String)"ecore", (String)resourceDescription.getURI().fileExtension())) continue;
            for (IEObjectDescription eObjectDescription : resourceDescription.getExportedObjectsByType(type)) {
                if (!name.equals((Object)eObjectDescription.getQualifiedName())) continue;
                return eObjectDescription.getEObjectURI();
            }
        }
        return null;
    }

    public static void setDisableWarning(boolean isDisableWarning) {
        EcoreRefactoringParticipant.isDisableWarning = isDisableWarning;
    }
}

