/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.highlighting;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseHighlightingCalculator
implements ISemanticHighlightingCalculator {
    @Inject
    private XbaseGrammarAccess grammarAccess;
    private Map<String, String> highlightedIdentifiers;
    private BitSet idLengthsToHighlight;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null) {
            return;
        }
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null || parseResult.getRootASTElement() == null) {
            return;
        }
        if (this.highlightedIdentifiers == null) {
            this.highlightedIdentifiers = this.initializeHighlightedIdentifiers();
            this.idLengthsToHighlight = new BitSet();
            for (String s : this.highlightedIdentifiers.keySet()) {
                this.idLengthsToHighlight.set(s.length());
            }
        }
        if (resource.isValidationDisabled()) {
            this.highlightSpecialIdentifiers(acceptor, parseResult.getRootNode());
            return;
        }
        this.doProvideHighlightingFor(resource, acceptor);
    }

    protected void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            throw new IllegalStateException("resource#parseResult may not be null");
        }
        ICompositeNode node = parseResult.getRootNode();
        this.highlightSpecialIdentifiers(acceptor, node);
        this.searchAndHighlightElements(resource, acceptor);
    }

    protected void searchAndHighlightElements(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        TreeIterator iterator = EcoreUtil2.eAll((EObject)resource.getParseResult().getRootASTElement());
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (object instanceof XAbstractFeatureCall) {
                if (((XAbstractFeatureCall)object).isPackageFragment()) {
                    iterator.prune();
                    continue;
                }
                this.computeFeatureCallHighlighting((XAbstractFeatureCall)object, acceptor);
            }
            if (object instanceof XNumberLiteral) {
                this.highlightNumberLiterals((XNumberLiteral)object, acceptor);
            }
            if (object instanceof XAnnotation) {
                this.highlightAnnotation((XAnnotation)object, acceptor);
                continue;
            }
            this.computeReferencedJvmTypeHighlighting(acceptor, object);
        }
    }

    protected void computeReferencedJvmTypeHighlighting(IHighlightedPositionAcceptor acceptor, EObject referencer) {
        for (EReference reference : referencer.eClass().getEAllReferences()) {
            EClass referencedType = reference.getEReferenceType();
            if (!EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_TYPE, (EClass)referencedType)) continue;
            List referencedObjects = EcoreUtil2.getAllReferencedObjects((EObject)referencer, (EReference)reference);
            for (EObject referencedObject : referencedObjects) {
                EObject resolvedReferencedObject = EcoreUtil.resolve((EObject)referencedObject, (EObject)referencer);
                if (resolvedReferencedObject == null || resolvedReferencedObject.eIsProxy()) continue;
                this.highlightReferenceJvmType(acceptor, referencer, reference, resolvedReferencedObject);
            }
        }
    }

    protected void highlightReferenceJvmType(IHighlightedPositionAcceptor acceptor, EObject referencer, EReference reference, EObject resolvedReferencedObject) {
        if (resolvedReferencedObject instanceof JvmAnnotationType) {
            this.highlightObjectAtFeature(acceptor, referencer, (EStructuralFeature)reference, "xbase.annotation");
        }
    }

    protected void computeFeatureCallHighlighting(XAbstractFeatureCall featureCall, IHighlightedPositionAcceptor acceptor) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy()) {
            JvmOperation jvmOperation;
            if (feature instanceof JvmField) {
                if (((JvmField)feature).isStatic()) {
                    this.highlightFeatureCall(featureCall, acceptor, "xbase.static.field");
                } else {
                    this.highlightFeatureCall(featureCall, acceptor, "xbase.field");
                }
            } else if (feature instanceof JvmOperation && !(featureCall instanceof XUnaryOperation) && !(featureCall instanceof XBinaryOperation) && (jvmOperation = (JvmOperation)feature).isStatic()) {
                this.highlightFeatureCall(featureCall, acceptor, "xbase.static.method.invocation");
            }
            XExpression implicitReceiver = featureCall.getImplicitReceiver();
            if (featureCall instanceof XMemberFeatureCall) {
                XMemberFeatureCall casted = (XMemberFeatureCall)featureCall;
                if (!feature.eIsProxy() && feature instanceof JvmOperation) {
                    if (((JvmOperation)feature).isStatic() && !casted.isStaticWithDeclaringType()) {
                        this.highlightFeatureCall(featureCall, acceptor, "xbase.extension.method.invacation");
                    }
                    if (implicitReceiver != null) {
                        this.highlightFeatureCall(featureCall, acceptor, "xbase.extension.method.invacation");
                    }
                }
            }
            if (featureCall instanceof XAssignment && ((XAssignment)featureCall).getValue() != null && !feature.eIsProxy() && feature instanceof JvmOperation && implicitReceiver instanceof XMemberFeatureCall && ((XMemberFeatureCall)implicitReceiver).getFeature() instanceof JvmField) {
                this.highlightFeatureCall(featureCall, acceptor, "xbase.extension.method.invacation");
            }
            if (featureCall instanceof XFeatureCall && !feature.eIsProxy() && feature instanceof JvmOperation && implicitReceiver != null && ((JvmOperation)feature).isStatic()) {
                this.highlightFeatureCall(featureCall, acceptor, "xbase.extension.method.invacation");
            }
            if ((featureCall instanceof XFeatureCall || featureCall instanceof XAssignment) && !feature.eIsProxy() && feature instanceof JvmOperation && featureCall.getImplicitFirstArgument() != null) {
                this.highlightFeatureCall(featureCall, acceptor, "xbase.extension.method.invacation");
            }
            if (feature instanceof JvmAnnotationTarget && DeprecationUtil.isDeprecated((JvmAnnotationTarget)((JvmAnnotationTarget)feature))) {
                this.highlightFeatureCall(featureCall, acceptor, "xbase.deprecated.members");
            }
        }
    }

    protected void highlightFeatureCall(XAbstractFeatureCall featureCall, IHighlightedPositionAcceptor acceptor, String id) {
        if (featureCall.isTypeLiteral()) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)featureCall);
            this.highlightNode((INode)node, id, acceptor);
        } else {
            this.highlightObjectAtFeature(acceptor, (EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, id);
        }
    }

    protected void highlightAnnotation(XAnnotation annotation, IHighlightedPositionAcceptor acceptor) {
        JvmType annotationType = annotation.getAnnotationType();
        if (annotationType != null && !annotationType.eIsProxy() && annotationType instanceof JvmAnnotationType) {
            ILeafNode firstLeafNode;
            ICompositeNode xannotationNode = NodeModelUtils.findActualNodeFor((EObject)annotation);
            if (xannotationNode != null && (firstLeafNode = NodeModelUtils.findLeafNodeAtOffset((INode)xannotationNode, (int)xannotationNode.getOffset())) != null) {
                this.highlightNode((INode)firstLeafNode, "xbase.annotation", acceptor);
            }
            this.highlightObjectAtFeature(acceptor, (EObject)annotation, (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, "xbase.annotation");
        }
    }

    protected void highlightNumberLiterals(XNumberLiteral literal, IHighlightedPositionAcceptor acceptor) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)literal);
        acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"number"});
    }

    protected void highlightSpecialIdentifiers(IHighlightedPositionAcceptor acceptor, ICompositeNode root) {
        TerminalRule idRule = this.grammarAccess.getIDRule();
        for (ILeafNode leaf : root.getLeafNodes()) {
            if (leaf.isHidden()) continue;
            this.highlightSpecialIdentifiers(leaf, acceptor, idRule);
        }
    }

    protected void highlightSpecialIdentifiers(ILeafNode leafNode, IHighlightedPositionAcceptor acceptor, TerminalRule idRule) {
        String text;
        String highlightingID;
        EObject element;
        if (this.idLengthsToHighlight.get(leafNode.getLength()) && ((element = leafNode.getGrammarElement()) == idRule || element instanceof RuleCall && ((RuleCall)element).getRule() == idRule) && (highlightingID = this.highlightedIdentifiers.get(text = leafNode.getText())) != null) {
            acceptor.addPosition(leafNode.getOffset(), leafNode.getLength(), new String[]{highlightingID});
        }
    }

    protected Map<String, String> initializeHighlightedIdentifiers() {
        HashMap result = Maps.newHashMap();
        Primitives.Primitive[] primitiveArray = Primitives.Primitive.values();
        int n = primitiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            Primitives.Primitive p = primitiveArray[n2];
            result.put(p.name().toLowerCase(), "keyword");
            ++n2;
        }
        result.put("this", "keyword");
        result.put("it", "keyword");
        return result;
    }

    protected void highlightObjectAtFeature(IHighlightedPositionAcceptor acceptor, EObject object, EStructuralFeature feature, String id) {
        List children = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
        if (children.size() > 0) {
            this.highlightNode((INode)children.get(0), id, acceptor);
        }
    }

    protected void highlightNode(INode node, String id, IHighlightedPositionAcceptor acceptor) {
        if (node == null) {
            return;
        }
        if (node instanceof ILeafNode) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{id});
        } else {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                acceptor.addPosition(leaf.getOffset(), leaf.getLength(), new String[]{id});
            }
        }
    }
}

