/*
* generated by Xtext
*/
package org.eclipse.xtend.ide.labeling;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;

import com.google.inject.Inject;

/**
 * Provides labels for a EObjects.
 * 
 * see http://www.eclipse.org/Xtext/documentation/latest/xtext.html#labelProvider
 */
public class XtendLabelProvider extends XbaseLabelProvider {
	
	@Inject
	private UIStrings uiStrings;

	@Inject
	private XtendImages images;

	@Inject
	private IXtendJvmAssociations associations;

	public XtendLabelProvider() {
		super(null);
	}

	public Image image(XtendFile element) {
		return images.forFile();
	}

	@Override
	public Image image(XImportDeclaration element) {
		return images.forImport();
	}

	public Image image(XtendClass element) {
		return images.forClass(element.getVisibility());
	}

	public Image image(XtendInterface element) {
		return images.forInterface(element.getVisibility());
	}

	public Image image(XtendEnum element) {
		return images.forEnum(element.getVisibility());
	}

	public Image image(XtendAnnotationType element) {
		return images.forAnnotation(element.getVisibility());
	}

	public Image image(XtendFunction element) {
		return images.forOperation(element.getVisibility(), element.isAbstract(), element.isStatic(), element.isFinal());
	}
	
	public Image image(XtendConstructor element) {
		return images.forConstructor(element.getVisibility());
	}

	public Image image(XtendField element) {
		return images.forField(element.getVisibility(), element.isStatic(), element.isFinal(), element.isExtension());
	}
	
	public Image image(XtendEnumLiteral element) {
		return images.forField(element.getVisibility(), element.isStatic(), element.isFinal(), false);
	}

	public String text(XtendFile element) {
		return element.eResource().getURI().trimFileExtension().lastSegment();
	}

	public String text(XImportDeclaration element) {
		return element.getImportedNamespace();
	}

	public String text(XtendClass element) {
		return element.getName() + ((element.getTypeParameters().isEmpty()) ? "" : uiStrings.typeParameters(element.getTypeParameters()));
	}

	public String text(XtendConstructor element) {
		return "new" + uiStrings.parameters(associations.getInferredConstructor(element));
	}
	
	public Object text(XtendFunction element) {
		return signature(element.getName(), associations.getDirectlyInferredOperation(element));
	}
	
	public StyledString text(XtendField element) {
		if (element.getName() == null && element.isExtension()) {
			return new StyledString(uiStrings.referenceToString(element.getType(), "extension"), StyledString.DECORATIONS_STYLER);
		}
		JvmTypeReference fieldType = getType(element);
		if (fieldType != null) {
			String type = uiStrings.referenceToString(fieldType, "");
			if (type.length() != 0) {
				return new StyledString(element.getName()).append(new StyledString(" : " + type,StyledString.DECORATIONS_STYLER));
			}
		}
		return new StyledString(element.getName());
	}
	
	protected JvmTypeReference getType(XtendField field) {
		JvmField jvmField = associations.getJvmField(field);
		if (jvmField != null) {
			return jvmField.getType();
		} else {
			Iterator<EObject> i = associations.getJvmElements(field).iterator();
			if(i.hasNext()) {
				EObject next = i.next();
				if(next instanceof JvmOperation)
					return ((JvmOperation)next).getReturnType();
			}
		}
		return null;
	}
}
