/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedExecutable;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.TracedAccessors;
import org.eclipse.xtext.generator.trace.node.TracingSugar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TracedAccessorsProcessor
extends AbstractClassProcessor {
    private static final Set<String> TYPES_WITH_GOOD_TO_STRING = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"string", "boolean", "int", "long", "integer"}));

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        TypeReference[] factories;
        annotatedClass.setExtendedClass(context.newTypeReference(TracingSugar.class, new TypeReference[0]));
        TypeReference iterableType = context.newTypeReference(Iterable.class, new TypeReference[]{context.newWildcardTypeReference()});
        TypeReference annotationType = context.newTypeReference(TracedAccessors.class, new TypeReference[0]);
        AnnotationReference annotation = annotatedClass.findAnnotation(annotationType.getType());
        TypeReference[] typeReferenceArray = factories = annotation == null ? null : annotation.getClassArrayValue("value");
        if (factories == null) {
            return;
        }
        for (InterfaceDeclaration f : Iterables.filter((Iterable)ListExtensions.map(Arrays.asList(factories), it -> it.getType()), InterfaceDeclaration.class)) {
            for (TypeReference t : FluentIterable.from((Iterable)f.getDeclaredMethods()).filter(it -> it.getSimpleName().startsWith("create") && Iterables.isEmpty((Iterable)it.getParameters())).transform(MethodDeclaration::getReturnType).toSortedList(Comparator.comparing(TypeReference::getSimpleName))) {
                for (final ResolvedMethod getter : FluentIterable.from((Iterable)t.getAllResolvedMethods()).filter(it -> this.isSupportedGetter((ResolvedMethod)it)).filter(it -> !iterableType.isAssignableFrom(it.getDeclaration().getReturnType())).toSortedList(Comparator.comparing(ResolvedExecutable::getSimpleSignature))) {
                    TypeReference rt = getter.getResolvedReturnType();
                    if (TYPES_WITH_GOOD_TO_STRING.contains(rt.getType().getSimpleName().toLowerCase())) {
                        annotatedClass.addMethod(this.tracerName(getter), it -> {
                            it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                            it.addParameter("target", t);
                            it.setBody(new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                                    builder.append(EStructuralFeature.class);
                                    builder.append((Object)" feature = target.eClass().getEStructuralFeature(\"");
                                    builder.append((Object)TracedAccessorsProcessor.this.featureName(getter));
                                    builder.append((Object)"\");");
                                    builder.newLineIfNotEmpty();
                                    builder.append(ILocationData.class);
                                    builder.append((Object)" location = this.location(target, feature, -1);");
                                    builder.newLineIfNotEmpty();
                                    builder.append(CompositeGeneratorNode.class);
                                    builder.append((Object)" trace = this.trace(location);");
                                    builder.newLineIfNotEmpty();
                                    builder.append((Object)"this.append(trace, target.");
                                    builder.append((Object)getter.getDeclaration().getSimpleName());
                                    builder.append((Object)"());");
                                    builder.newLineIfNotEmpty();
                                    builder.append((Object)"return trace;");
                                    builder.newLine();
                                }
                            });
                        });
                        annotatedClass.addMethod(this.tracerName(getter), it -> {
                            it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                            it.addParameter("target", t);
                            it.addParameter("useForDebugging", context.newTypeReference(Boolean.TYPE, new TypeReference[0]));
                            it.setBody(new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                                    builder.append(EStructuralFeature.class);
                                    builder.append((Object)" feature = target.eClass().getEStructuralFeature(\"");
                                    builder.append((Object)TracedAccessorsProcessor.this.featureName(getter));
                                    builder.append((Object)"\");");
                                    builder.newLineIfNotEmpty();
                                    builder.append(ILocationData.class);
                                    builder.append((Object)" location = this.location(target, feature, -1);");
                                    builder.newLineIfNotEmpty();
                                    builder.append(CompositeGeneratorNode.class);
                                    builder.append((Object)" trace = this.trace(location, useForDebugging);");
                                    builder.newLineIfNotEmpty();
                                    builder.append((Object)"this.append(trace, target.");
                                    builder.append((Object)getter.getDeclaration().getSimpleName());
                                    builder.append((Object)"());");
                                    builder.newLineIfNotEmpty();
                                    builder.append((Object)"return trace;");
                                    builder.newLine();
                                }
                            });
                        });
                    }
                    annotatedClass.addMethod(this.tracerName(getter), it -> {
                        it.setReturnType(context.newTypeReference(IGeneratorNode.class, new TypeReference[0]));
                        it.addParameter("target", t);
                        it.addParameter("stringProvider", context.newTypeReference(Function.class, new TypeReference[]{rt, context.getString()}));
                        it.setBody(new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                                builder.append(EStructuralFeature.class);
                                builder.append((Object)" feature = target.eClass().getEStructuralFeature(\"");
                                builder.append((Object)TracedAccessorsProcessor.this.featureName(getter));
                                builder.append((Object)"\");");
                                builder.newLineIfNotEmpty();
                                builder.append(ILocationData.class);
                                builder.append((Object)" location = this.location(target, feature, -1);");
                                builder.newLineIfNotEmpty();
                                builder.append(CompositeGeneratorNode.class);
                                builder.append((Object)" trace = this.trace(location);");
                                builder.newLineIfNotEmpty();
                                builder.append((Object)"this.append(trace, stringProvider.apply(target.");
                                builder.append((Object)getter.getDeclaration().getSimpleName());
                                builder.append((Object)"()));");
                                builder.newLineIfNotEmpty();
                                builder.append((Object)"return trace;");
                                builder.newLine();
                            }
                        });
                    });
                }
            }
        }
    }

    public String tracerName(ResolvedMethod m) {
        return "_" + this.featureName(m);
    }

    public String featureName(ResolvedMethod m) {
        int skip = m.getDeclaration().getSimpleName().startsWith("get") ? 3 : 2;
        return StringExtensions.toFirstLower((String)m.getDeclaration().getSimpleName().substring(skip));
    }

    public boolean isSupportedGetter(ResolvedMethod it) {
        if (!IterableExtensions.isEmpty((Iterable)it.getDeclaration().getParameters())) {
            return false;
        }
        if (it.getDeclaration().isStatic()) {
            return false;
        }
        String n = it.getDeclaration().getSimpleName();
        if (Object.class.getName().equals(it.getDeclaration().getDeclaringType().getQualifiedName())) {
            return false;
        }
        return n.startsWith("get") || n.startsWith("is");
    }
}

