/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.regionaccess.IAstRegion;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;

public class InsertionPointFinder {
    private SerializationContextMap<Pda<ISerState, RuleCall>> pdas;

    protected Set<AbstractElement> collectAdjacent(ISerState start, Function<ISerState, List<? extends ISerState>> followers) {
        LinkedList todo = new LinkedList();
        HashSet seen = Sets.newHashSet();
        todo.addAll(followers.apply(start));
        LinkedHashSet result = Sets.newLinkedHashSet();
        while (!todo.isEmpty()) {
            ISerState next = (ISerState)todo.pop();
            if (!seen.add(next)) continue;
            if (next.getType() == ISerState.SerStateType.ELEMENT && !GrammarUtil.isUnassignedAction((EObject)next.getGrammarElement())) {
                result.add(next.getGrammarElement());
                continue;
            }
            todo.addAll(followers.apply(next));
        }
        return result;
    }

    public IHiddenRegion findInsertionPoint(ISerializationContext ctx, IEObjectRegion obj, AbstractElement ins) {
        ISerState insertionState = this.findState(ctx, ins);
        Set<AbstractElement> followers = this.collectAdjacent(insertionState, s -> s.getFollowers());
        Set<AbstractElement> precendents = this.collectAdjacent(insertionState, s -> s.getPrecedents());
        ArrayList regions = Lists.newArrayList((Iterable)obj.getAstRegions());
        if (regions.isEmpty()) {
            return obj.getPreviousHiddenRegion();
        }
        if (followers.contains(((IAstRegion)regions.get(0)).getGrammarElement())) {
            return obj.getPreviousHiddenRegion();
        }
        if (precendents.contains(((IAstRegion)regions.get(regions.size() - 1)).getGrammarElement())) {
            return obj.getNextHiddenRegion();
        }
        for (int i = 0; i < regions.size() - 1; ++i) {
            IAstRegion leading = (IAstRegion)regions.get(i);
            IAstRegion trailing = (IAstRegion)regions.get(i + 1);
            if (!precendents.contains(leading.getGrammarElement()) || !followers.contains(trailing.getGrammarElement())) continue;
            return leading.getNextHiddenRegion();
        }
        return null;
    }

    protected ISerState findState(ISerializationContext ctx, AbstractElement ele) {
        Pda pda = (Pda)this.pdas.get(ctx);
        return (ISerState)new NfaUtil().find((Nfa)pda, s -> s.getGrammarElement() == ele);
    }

    @Inject
    protected void init(IContextTypePDAProvider pdaProvider, IGrammarAccess grammar) {
        this.pdas = pdaProvider.getContextTypePDAs(grammar.getGrammar());
    }
}

