/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.wizard;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.idea.XtextXtextIcons;
import org.eclipse.xtext.idea.lang.XtextLanguage;
import org.eclipse.xtext.idea.util.ProjectLifecycleUtil;
import org.eclipse.xtext.idea.wizard.IdeaProjectCreator;
import org.eclipse.xtext.idea.wizard.XtextWizardStep;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.wizard.ParentProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.WizardConfiguration;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class XtextModuleBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance((String)XtextWizardStep.class.getName());
    @Inject
    @Extension
    private ProjectLifecycleUtil _projectLifecycleUtil;
    @Inject
    private Provider<WizardConfiguration> wizardConfigProvider;
    @Inject
    private WizardConfiguration wizardConfiguration;
    @Inject
    private IdeaProjectCreator.Factory projectCreatorfactory;

    public XtextModuleBuilder() {
        WizardConfiguration _get;
        XtextLanguage.INSTANCE.injectMembers((Object)this);
        this.wizardConfiguration = _get = (WizardConfiguration)this.wizardConfigProvider.get();
    }

    public Icon getNodeIcon() {
        return XtextXtextIcons.GRAMMAR_FILE_TYPE;
    }

    public String getDescription() {
        return "Xtext Language Project";
    }

    public String getPresentableName() {
        return "Xtext";
    }

    public String getGroupName() {
        return "Xtext";
    }

    public String getBuilderId() {
        return "xtextModuleBuilder";
    }

    public String getParentGroup() {
        return "Java";
    }

    public int getWeight() {
        return 53;
    }

    public ModuleType<?> getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        JavaSdk _instance = JavaSdk.getInstance();
        return sdk == _instance;
    }

    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new XtextWizardStep(context);
    }

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        String _contentEntryPath = this.getContentEntryPath();
        String path = FileUtil.toSystemIndependentName((String)_contentEntryPath);
        File _file = new File(path);
        _file.mkdirs();
        LocalFileSystem _instance = LocalFileSystem.getInstance();
        VirtualFile root = _instance.refreshAndFindFileByPath(path);
        rootModel.addContentEntry(root);
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
    }

    public Module commitModule(Project project, ModifiableModuleModel model) {
        List<Module> modulesCreated = this.commit(project, model, null);
        ParentProjectDescriptor _parentProject = this.wizardConfiguration.getParentProject();
        boolean _isEnabled = _parentProject.isEnabled();
        if (_isEnabled) {
            Functions.Function1<Module, Boolean> _function = new Functions.Function1<Module, Boolean>(){

                public Boolean apply(Module module) {
                    String _name = module.getName();
                    ParentProjectDescriptor _parentProject = XtextModuleBuilder.this.wizardConfiguration.getParentProject();
                    String _name_1 = _parentProject.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            return (Module)IterableExtensions.findFirst(modulesCreated, (Functions.Function1)_function);
        }
        Functions.Function1<Module, Boolean> _function_1 = new Functions.Function1<Module, Boolean>(){

            public Boolean apply(Module module) {
                String _name = XtextModuleBuilder.this.getName();
                String _name_1 = module.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            }
        };
        return (Module)IterableExtensions.findFirst(modulesCreated, (Functions.Function1)_function_1);
    }

    public List<Module> commit(final Project project, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        boolean _needsGradleBuild;
        ModifiableModuleModel _xifexpression = null;
        if (model != null) {
            _xifexpression = model;
        } else {
            ModuleManager _instance = ModuleManager.getInstance((Project)project);
            _xifexpression = _instance.getModifiableModel();
        }
        final ModifiableModuleModel moduleModel = _xifexpression;
        this.setupWizardConfiguration(this.wizardConfiguration);
        VirtualFile _baseDir = project.getBaseDir();
        String _path = _baseDir.getPath();
        this.wizardConfiguration.setRootLocation(_path);
        String _name = this.getName();
        this.wizardConfiguration.setBaseName(_name);
        Application _application = ApplicationManager.getApplication();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                IdeaProjectCreator _create = XtextModuleBuilder.this.projectCreatorfactory.create(moduleModel);
                _create.createProjects(XtextModuleBuilder.this.wizardConfiguration);
                moduleModel.commit();
            }
        };
        _application.runWriteAction(_function);
        boolean _needsMavenBuild = this.wizardConfiguration.needsMavenBuild();
        if (_needsMavenBuild) {
            Runnable _function_1 = new Runnable(){

                @Override
                public void run() {
                    MavenProjectsManager manager = MavenProjectsManager.getInstance((Project)project);
                    if (manager != null) {
                        ParentProjectDescriptor _parentProject = XtextModuleBuilder.this.wizardConfiguration.getParentProject();
                        String _location = _parentProject.getLocation();
                        String _plus = _location + File.separator;
                        String pomFilePath = _plus + "pom.xml";
                        LocalFileSystem _instance = LocalFileSystem.getInstance();
                        VirtualFile virtualFile = _instance.refreshAndFindFileByPath(pomFilePath);
                        if (virtualFile != null) {
                            manager.addManagedFilesOrUnignore(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new VirtualFile[]{virtualFile})));
                        } else {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"Can't start maven import. File ");
                            _builder.append((Object)pomFilePath, "");
                            _builder.append((Object)" does not exists.");
                            LOG.error((Object)_builder);
                        }
                    }
                }
            };
            this._projectLifecycleUtil.executeWhenProjectReady(project, _function_1);
        }
        if (_needsGradleBuild = this.wizardConfiguration.needsGradleBuild()) {
            GradleProjectSettings gradleProjectSettings = new GradleProjectSettings();
            ParentProjectDescriptor _parentProject = this.wizardConfiguration.getParentProject();
            String _location = _parentProject.getLocation();
            gradleProjectSettings.setExternalProjectPath(_location);
            gradleProjectSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            settings.linkProject((ExternalProjectSettings)gradleProjectSettings);
            ParentProjectDescriptor _parentProject_1 = this.wizardConfiguration.getParentProject();
            String _location_1 = _parentProject_1.getLocation();
            ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)_location_1, (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC);
        }
        return (List)Conversions.doWrapArray((Object)moduleModel.getModules());
    }

    public void setupWizardConfiguration(WizardConfiguration wizardConfiguration) {
        wizardConfiguration.setNeedsGradleWrapper(false);
    }

    public WizardConfiguration getWizardConfiguration() {
        return this.wizardConfiguration;
    }
}

