/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.editorActions;

import com.google.inject.Inject;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import javax.inject.Singleton;
import org.eclipse.xtext.idea.editorActions.TokenSetProvider;
import org.eclipse.xtext.idea.parser.TokenTypeProvider;

@Singleton
public class DefaultTokenSetProvider
implements TokenSetProvider {
    @Inject
    private TokenTypeProvider tokenTypeProvider;
    private TokenSet slCommentTokens;
    private TokenSet mlCommentTokens;

    @Inject
    public void setCommenter(CodeDocumentationAwareCommenter commenter) {
        TokenSet _create_1;
        TokenSet _create;
        IElementType _lineCommentTokenType = commenter.getLineCommentTokenType();
        this.slCommentTokens = _create = TokenSet.create((IElementType[])new IElementType[]{_lineCommentTokenType});
        IElementType _blockCommentTokenType = commenter.getBlockCommentTokenType();
        this.mlCommentTokens = _create_1 = TokenSet.create((IElementType[])new IElementType[]{_blockCommentTokenType});
    }

    @Override
    public TokenSet getTokenSet(EditorEx editor, int offset) {
        IElementType _tokenType = this.getTokenType(editor, offset);
        return this.getTokenSet(_tokenType);
    }

    @Override
    public TokenSet getTokenSet(IElementType tokenType) {
        TokenSet _stringLiteralTokens = this.getStringLiteralTokens();
        boolean _contains = _stringLiteralTokens.contains(tokenType);
        if (_contains) {
            return this.getStringLiteralTokens();
        }
        TokenSet _singleLineCommentTokens = this.getSingleLineCommentTokens();
        boolean _contains_1 = _singleLineCommentTokens.contains(tokenType);
        if (_contains_1) {
            return this.getSingleLineCommentTokens();
        }
        TokenSet _multiLineCommentTokens = this.getMultiLineCommentTokens();
        boolean _contains_2 = _multiLineCommentTokens.contains(tokenType);
        if (_contains_2) {
            return this.getMultiLineCommentTokens();
        }
        TokenSet _commentTokens = this.getCommentTokens();
        boolean _contains_3 = _commentTokens.contains(tokenType);
        if (_contains_3) {
            return this.getCommentTokens();
        }
        return this.getDefaultTokens();
    }

    protected IElementType getTokenType(EditorEx editor, int offset) {
        DocumentEx _document;
        int _textLength;
        boolean _greaterThan;
        IElementType _xblockexpression = null;
        boolean _or = false;
        _or = offset < 0 ? true : (_greaterThan = offset > (_textLength = (_document = editor.getDocument()).getTextLength()));
        if (_or) {
            return null;
        }
        EditorHighlighter _highlighter = editor.getHighlighter();
        HighlighterIterator iterator = _highlighter.createIterator(offset);
        boolean _atEnd = iterator.atEnd();
        if (_atEnd) {
            return null;
        }
        _xblockexpression = iterator.getTokenType();
        return _xblockexpression;
    }

    @Override
    public TokenSet getCommentTokens() {
        return this.tokenTypeProvider.getCommentTokens();
    }

    @Override
    public TokenSet getSingleLineCommentTokens() {
        return this.slCommentTokens;
    }

    @Override
    public TokenSet getMultiLineCommentTokens() {
        return this.mlCommentTokens;
    }

    @Override
    public TokenSet getStringLiteralTokens() {
        return this.tokenTypeProvider.getStringLiteralTokens();
    }

    @Override
    public boolean isStartOfLine(EditorEx editor, int offset) {
        TokenSet _tokenSet = this.getTokenSet(editor, offset);
        return this.isStartOfLine(_tokenSet, editor, offset);
    }

    @Override
    public boolean isStartOfLine(TokenSet tokenSet, EditorEx editor, int offset) {
        String _beginningOfLine = this.getBeginningOfLine(editor, offset);
        String _trim = _beginningOfLine.trim();
        return _trim.isEmpty();
    }

    @Override
    public boolean isEndOfLine(EditorEx editor, int offset) {
        TokenSet _tokenSet = this.getTokenSet(editor, offset);
        return this.isEndOfLine(_tokenSet, editor, offset);
    }

    @Override
    public boolean isEndOfLine(TokenSet tokenSet, EditorEx editor, int offset) {
        String _endOfLine = this.getEndOfLine(editor, offset);
        String _trim = _endOfLine.trim();
        return _trim.isEmpty();
    }

    protected String getBeginningOfLine(EditorEx editor, int offset) {
        String _xblockexpression = null;
        DocumentEx document = editor.getDocument();
        DocumentEx _document = editor.getDocument();
        int lineNumber = _document.getLineNumber(offset);
        DocumentEx _document_1 = editor.getDocument();
        int lineStartOffset = _document_1.getLineStartOffset(lineNumber);
        TextRange _textRange = new TextRange(lineStartOffset, offset);
        _xblockexpression = document.getText(_textRange);
        return _xblockexpression;
    }

    protected String getEndOfLine(EditorEx editor, int offset) {
        String _xblockexpression = null;
        DocumentEx document = editor.getDocument();
        DocumentEx _document = editor.getDocument();
        int lineNumber = _document.getLineNumber(offset);
        DocumentEx _document_1 = editor.getDocument();
        int lineEndOffset = _document_1.getLineEndOffset(lineNumber);
        TextRange _textRange = new TextRange(offset, lineEndOffset);
        _xblockexpression = document.getText(_textRange);
        return _xblockexpression;
    }

    @Override
    public TokenSet getDefaultTokens() {
        return null;
    }
}

