/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.editorActions;

import com.google.common.base.Objects;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.TokenSet;
import org.eclipse.xtext.idea.editorActions.AbstractAutoEditBlock;
import org.eclipse.xtext.idea.editorActions.AutoEditContext;
import org.eclipse.xtext.idea.editorActions.AutoEditStringRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Extension;

public class AutoEditString
extends AbstractAutoEditBlock {
    private final TokenSet stringLiteralTokens;

    public AutoEditString(String quote, TokenSet stringLiteralTokens) {
        this(quote, quote, stringLiteralTokens);
    }

    public AutoEditString(String openingTerminal, String closingTerminal, TokenSet stringLiteralTokens) {
        super(openingTerminal, closingTerminal);
        this.setShouldDeleteClosing(true);
        this.stringLiteralTokens = stringLiteralTokens;
    }

    @Override
    public void open(char c, @Extension AutoEditContext context) {
        int newCaretOffset = context.type(c);
        boolean _shouldInsertClosingQuote = this.shouldInsertClosingQuote(newCaretOffset, context);
        if (_shouldInsertClosingQuote) {
            DocumentEx _document = context.getDocument();
            String _closingTerminal = this.getClosingTerminal();
            _document.insertString(newCaretOffset, (CharSequence)_closingTerminal);
        }
    }

    @Override
    public boolean close(char c, @Extension AutoEditContext context) {
        int _caretOffset = context.getCaretOffset();
        AutoEditStringRegion stringRegion = this.findRegion(_caretOffset, context);
        boolean _equals = Objects.equal((Object)stringRegion, null);
        if (_equals) {
            return false;
        }
        TextRegion _closingTerminal = stringRegion.getClosingTerminal();
        boolean _equals_1 = Objects.equal((Object)_closingTerminal, null);
        if (_equals_1) {
            context.type(c);
        } else {
            int _caretOffset_1;
            TextRegion _closingTerminal_1 = stringRegion.getClosingTerminal();
            boolean _contains = _closingTerminal_1.contains(_caretOffset_1 = context.getCaretOffset());
            if (_contains) {
                EditorEx _editor = context.getEditor();
                EditorModificationUtil.moveCaretRelatively((Editor)_editor, (int)1);
            } else {
                context.type(c);
            }
        }
        return true;
    }

    protected AutoEditStringRegion findRegion(int offset, @Extension AutoEditContext context) {
        boolean _notEquals;
        TextRegion openingTerminal = this.findOpeningTerminal(offset, context);
        boolean _equals = Objects.equal((Object)openingTerminal, null);
        if (_equals) {
            return null;
        }
        int _offset = openingTerminal.getOffset();
        TextRegion closingTerminal = this.findClosingTerminal(offset, _offset, context);
        boolean bl = _notEquals = !Objects.equal((Object)closingTerminal, null);
        if (_notEquals) {
            boolean _lessEqualsThan;
            int _length;
            boolean _greaterEqualsThan;
            int _offset_1 = openingTerminal.getOffset();
            boolean bl2 = _greaterEqualsThan = _offset_1 >= offset;
            if (_greaterEqualsThan) {
                return null;
            }
            int _offset_2 = closingTerminal.getOffset();
            int _plus = _offset_2 + (_length = closingTerminal.getLength());
            boolean bl3 = _lessEqualsThan = _plus <= offset;
            if (_lessEqualsThan) {
                return null;
            }
        }
        return new AutoEditStringRegion(openingTerminal, closingTerminal);
    }

    protected TextRegion findOpeningTerminal(int offset, @Extension AutoEditContext context) {
        boolean _not;
        Object _xblockexpression = null;
        HighlighterIterator iterator = context.createTokenIterator(offset);
        boolean _isStringLiteral = this.isStringLiteral(iterator, context);
        boolean bl = _not = !_isStringLiteral;
        if (_not) {
            return null;
        }
        while (!iterator.atEnd()) {
            boolean _notEquals;
            TextRegion openingTerminal = this.getOpeningTerminal(iterator, context);
            boolean bl2 = _notEquals = !Objects.equal((Object)openingTerminal, null);
            if (_notEquals) {
                return openingTerminal;
            }
            iterator.retreat();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected TextRegion findClosingTerminal(int offset, int openingTokenOffset, @Extension AutoEditContext context) {
        boolean _not;
        Object _xblockexpression = null;
        HighlighterIterator iterator = context.createTokenIterator(offset);
        boolean _isStringLiteral = this.isStringLiteral(iterator, context);
        boolean bl = _not = !_isStringLiteral;
        if (_not) {
            return null;
        }
        while (!iterator.atEnd()) {
            boolean _notEquals;
            TextRegion closingTerminal = this.getClosingTerminal(iterator, openingTokenOffset, context);
            boolean bl2 = _notEquals = !Objects.equal((Object)closingTerminal, null);
            if (_notEquals) {
                return closingTerminal;
            }
            iterator.advance();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected TextRegion getOpeningTerminal(HighlighterIterator iterator, @Extension AutoEditContext context) {
        String _openingTerminal_2;
        boolean _notEquals;
        String _openingTerminal_1;
        int _length_1;
        int _start_2;
        int _plus;
        String _openingTerminal;
        int _length;
        boolean _lessThan;
        int _start;
        boolean _equals = Objects.equal((Object)iterator, null);
        if (_equals) {
            return null;
        }
        int _end = iterator.getEnd();
        int _minus = _end - (_start = iterator.getStart());
        boolean bl = _lessThan = _minus < (_length = (_openingTerminal = this.getOpeningTerminal()).length());
        if (_lessThan) {
            return null;
        }
        int _start_1 = iterator.getStart();
        String _text = context.getText(_start_1, _plus = (_start_2 = iterator.getStart()) + (_length_1 = (_openingTerminal_1 = this.getOpeningTerminal()).length()));
        boolean bl2 = _notEquals = !Objects.equal((Object)_text, (Object)(_openingTerminal_2 = this.getOpeningTerminal()));
        if (_notEquals) {
            return null;
        }
        int _start_3 = iterator.getStart();
        String _openingTerminal_3 = this.getOpeningTerminal();
        int _length_2 = _openingTerminal_3.length();
        return new TextRegion(_start_3, _length_2);
    }

    protected TextRegion getClosingTerminal(HighlighterIterator iterator, int openingTokenOffset, @Extension AutoEditContext context) {
        String _closingTerminal_2;
        boolean _notEquals;
        int _end_2;
        String _closingTerminal_1;
        int _length_2;
        String _closingTerminal;
        int _length_1;
        String _openingTerminal;
        int _length;
        int _plus;
        boolean _lessThan;
        boolean _equals = Objects.equal((Object)iterator, null);
        if (_equals) {
            return null;
        }
        int _end = iterator.getEnd();
        int _minus = _end - openingTokenOffset;
        boolean bl = _lessThan = _minus < (_plus = (_length = (_openingTerminal = this.getOpeningTerminal()).length()) + (_length_1 = (_closingTerminal = this.getClosingTerminal()).length()));
        if (_lessThan) {
            return null;
        }
        int _end_1 = iterator.getEnd();
        int _minus_1 = _end_1 - (_length_2 = (_closingTerminal_1 = this.getClosingTerminal()).length());
        String _text = context.getText(_minus_1, _end_2 = iterator.getEnd());
        boolean bl2 = _notEquals = !Objects.equal((Object)_text, (Object)(_closingTerminal_2 = this.getClosingTerminal()));
        if (_notEquals) {
            return null;
        }
        int _end_3 = iterator.getEnd();
        String _closingTerminal_3 = this.getClosingTerminal();
        int _length_3 = _closingTerminal_3.length();
        int _minus_2 = _end_3 - _length_3;
        String _closingTerminal_4 = this.getClosingTerminal();
        int _length_4 = _closingTerminal_4.length();
        return new TextRegion(_minus_2, _length_4);
    }

    protected boolean shouldInsertClosingQuote(int offset, @Extension AutoEditContext context) {
        boolean _isIdentifierPart = context.isIdentifierPart(offset);
        return !_isIdentifierPart;
    }

    protected boolean isStringLiteral(HighlighterIterator iterator, @Extension AutoEditContext context) {
        boolean _xblockexpression = false;
        boolean _atEnd = iterator.atEnd();
        if (_atEnd) {
            return false;
        }
        TokenSet _tokenSet = context.getTokenSet(iterator);
        _xblockexpression = this.isStringLiteral(_tokenSet, context);
        return _xblockexpression;
    }

    protected boolean isStringLiteral(TokenSet tokenSet, @Extension AutoEditContext context) {
        return Objects.equal((Object)tokenSet, (Object)this.stringLiteralTokens);
    }
}

