/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.debug;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.idea.debug.DebugProcessExtensions;
import org.eclipse.xtext.idea.lang.IXtextLanguage;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class SkippingUnwantedSteppingFilter
implements ExtraSteppingFilter {
    @Inject
    @Extension
    private DebugProcessExtensions _debugProcessExtensions;

    public SkippingUnwantedSteppingFilter(IXtextLanguage language) {
        language.injectMembers(this);
    }

    public int getStepRequestDepth(SuspendContext context) {
        boolean _isEmptyAnonymousClassConstructor = this.isEmptyAnonymousClassConstructor(context);
        if (_isEmptyAnonymousClassConstructor) {
            return 3;
        }
        return 2;
    }

    public boolean isApplicable(SuspendContext context) {
        try {
            boolean _isXtextSourced;
            boolean _not;
            boolean _or = false;
            boolean _equals = Objects.equal((Object)context, null);
            _or = _equals ? true : (_not = !(_isXtextSourced = this.isXtextSourced(context)));
            if (_or) {
                return false;
            }
            DebugProcess debugProcess = context.getDebugProcess();
            PositionManager positionManager = debugProcess.getPositionManager();
            StackFrameProxy _frameProxy = context.getFrameProxy();
            Location location = _frameProxy.location();
            boolean _isEmptyAnonymousClassConstructor = this.isEmptyAnonymousClassConstructor(context);
            if (_isEmptyAnonymousClassConstructor) {
                return true;
            }
            SourcePosition _sourcePosition = positionManager.getSourcePosition(location);
            boolean result = Objects.equal((Object)_sourcePosition, null);
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected boolean isXtextSourced(SuspendContext context) {
        try {
            StackFrameProxy _frameProxy = context.getFrameProxy();
            Location location = _frameProxy.location();
            DebugProcess _debugProcess = context.getDebugProcess();
            URI _findOriginalDeclaration = this._debugProcessExtensions.findOriginalDeclaration(_debugProcess, location);
            return !Objects.equal((Object)_findOriginalDeclaration, null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean isEmptyAnonymousClassConstructor(SuspendContext context) {
        try {
            boolean _notEquals;
            StackFrameProxy _frameProxy = context.getFrameProxy();
            Location location = _frameProxy.location();
            boolean bl = _notEquals = !Objects.equal((Object)location, null);
            if (_notEquals) {
                ReferenceType _declaringType;
                String _name;
                int _indexOf;
                boolean _greaterThan;
                boolean _isConstructor;
                Method method = location.method();
                boolean _and = false;
                boolean _and_1 = false;
                boolean _and_2 = false;
                boolean _notEquals_1 = !Objects.equal((Object)method, null);
                _and_2 = !_notEquals_1 ? false : (_isConstructor = method.isConstructor());
                if (!_and_2) {
                    _and_1 = false;
                } else {
                    boolean _isEmpty;
                    List<Type> _argumentTypes = method.argumentTypes();
                    _and_1 = _isEmpty = _argumentTypes.isEmpty();
                }
                _and = !_and_1 ? false : (_greaterThan = (_indexOf = (_name = (_declaringType = method.declaringType()).name()).indexOf("$")) > 0);
                if (_and) {
                    return true;
                }
            }
            return false;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

